---
generated_at: 2026-02-10 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：31-保存済みリビジョン数取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` - getSavedRevisionsCount関数（424-428行目）
- E-02: `src/node/db/Pad.ts` - getSavedRevisionsNumber()メソッド（77-79行目）
- E-03: `src/node/db/Pad.ts` - savedRevisionsプロパティ定義（49行目）
- E-04: `src/node/handler/RestAPI.ts` - エンドポイント定義（1158-1172行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getSavedRevisionsCount関数がパッドの保存済みリビジョン数を返す | E-01 | ○ |
| C-02 | getSavedRevisionsNumber()がsavedRevisions.lengthを返す | E-02 | ○ |
| C-03 | savedRevisionsは配列型で管理される | E-03 | ○ |
| C-04 | REST APIエンドポイントはGET /savedRevisions/revisionsCount | E-04 | ○ |
| C-05 | APIバージョン1.2.11で追加された | E-04 | ○ |
| C-06 | 入力パラメータはpadIDのみ | E-01, E-04 | ○ |
| C-07 | 出力はsavedRevisionsフィールドに数値を返す | E-01 | ○ |
| C-08 | パッドが存在しない場合はエラーを返す | E-01 | ○ |
| C-09 | getPadSafe関数でパッドの存在確認を行う | E-01 | ○ |
| C-10 | 機能名は「保存済みリビジョン数取得」 | E-05 | ○ |
| C-11 | カテゴリは「リビジョン管理」 | E-05 | ○ |
| C-12 | 読み取り専用操作である | E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより検証済み

## 6) レビュアーチェックリスト（最小）

- [x] API関数の実装がソースコードと一致している
- [x] エンドポイントのパスとHTTPメソッドが正確
- [x] 入出力パラメータの記載が正確
- [x] エラーケースの網羅性
