---
generated_at: 2026-02-10 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-リビジョン復元

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` - restoreRevision関数（548-601行目）
- E-02: `src/node/db/Pad.ts` - getInternalRevisionAText()メソッド（208-221行目）
- E-03: `src/node/db/Pad.ts` - appendRevision()メソッド（97-144行目）
- E-04: `src/node/handler/RestAPI.ts` - エンドポイント定義（1334-1360行目）
- E-05: `src/node/handler/PadMessageHandler.ts` - updatePadClients()関数（738-795行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | restoreRevision関数が過去のリビジョンを復元する | E-01 | ○ |
| C-02 | revパラメータは必須でundefinedの場合エラー | E-01 (550-552行目) | ○ |
| C-03 | revはcheckValidRevで検証される | E-01 (553行目) | ○ |
| C-04 | revがhead超過の場合エラー | E-01 (559-561行目) | ○ |
| C-05 | getInternalRevisionATextで指定リビジョンのatextを取得 | E-01, E-02 | ○ |
| C-06 | Builderを使用して変更セットを構築 | E-01 (582-597行目) | ○ |
| C-07 | appendRevisionで新しいリビジョンとして追加 | E-01, E-03 | ○ |
| C-08 | updatePadClientsで接続中クライアントに通知 | E-01, E-05 | ○ |
| C-09 | REST APIエンドポイントはPATCH /savedRevisions | E-04 | ○ |
| C-10 | APIバージョン1.3.0で追加された | E-04 | ○ |
| C-11 | 入力パラメータはpadID, rev, authorId | E-01, E-04 | ○ |
| C-12 | authorIdはオプションで空文字列がデフォルト | E-01 (548行目) | ○ |
| C-13 | 復元は非破壊的で履歴は保持される | E-01 (新リビジョン追加方式) | ○ |
| C-14 | 機能名は「リビジョン復元」 | E-06 | ○ |
| C-15 | カテゴリは「リビジョン管理」 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより検証済み

## 6) レビュアーチェックリスト（最小）

- [x] API関数の実装がソースコードと一致している
- [x] エンドポイントのパスとHTTPメソッドが正確
- [x] 入出力パラメータの記載が正確
- [x] エラーケースの網羅性
- [x] 変更セット構築ロジックの正確性
- [x] クライアント通知処理の記載
