---
generated_at: 2026-02-10 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-差分HTML作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` - createDiffHTML関数（830-859行目）
- E-02: `src/node/utils/padDiff.ts` - PadDiffクラス全体
- E-03: `src/node/utils/padDiff.ts` - _createDiffAtext()メソッド（133-186行目）
- E-04: `src/node/utils/padDiff.ts` - getHtml()メソッド（187-203行目）
- E-05: `src/node/utils/padDiff.ts` - _extendChangesetWithAuthor()メソッド（215-241行目）
- E-06: `src/node/handler/RestAPI.ts` - エンドポイント定義（894-920行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createDiffHTML関数が2つのリビジョン間の差分HTMLを生成 | E-01 | ○ |
| C-02 | PadDiffオブジェクトで差分計算を行う | E-01, E-02 | ○ |
| C-03 | startRev/endRevがheadを超える場合は自動調整 | E-01 (844-846行目) | ○ |
| C-04 | getHtml()で差分HTMLを生成 | E-04 | ○ |
| C-05 | getAuthors()で著者一覧を取得 | E-02 (205-213行目) | ○ |
| C-06 | 削除操作にremoved属性を付与 | E-05 (222-224行目) | ○ |
| C-07 | REST APIエンドポイントはPOST /pads/diff | E-06 | ○ |
| C-08 | APIバージョン1.2.7で追加された | E-06 | ○ |
| C-09 | 入力パラメータはpadID, startRev, endRev | E-01, E-06 | ○ |
| C-10 | 出力はhtml, authorsを含むオブジェクト | E-01 (858行目) | ○ |
| C-11 | _createClearStartAtextで開始atextをクリア | E-03 (137行目) | ○ |
| C-12 | bulkSize: 100で一括取得 | E-03 (134行目) | ○ |
| C-13 | 機能名は「差分HTML作成」 | E-07 | ○ |
| C-14 | カテゴリは「リビジョン管理」 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより検証済み

## 6) レビュアーチェックリスト（最小）

- [x] API関数の実装がソースコードと一致している
- [x] エンドポイントのパスとHTTPメソッドが正確
- [x] 入出力パラメータの記載が正確
- [x] PadDiffクラスの処理フローが正確
- [x] エラーケースの網羅性
