---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-グループ削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/GroupManager.ts` 45-78行目（deleteGroup関数実装）
- E-02: `src/node/db/GroupManager.ts` 46-52行目（グループ存在確認）
- E-03: `src/node/db/GroupManager.ts` 55-58行目（パッド削除Promise.all）
- E-04: `src/node/db/GroupManager.ts` 62-65行目（セッション削除Promise.all）
- E-05: `src/node/db/GroupManager.ts` 67-74行目（関連レコード削除Promise.all）
- E-06: `src/node/db/GroupManager.ts` 77行目（グループ本体削除）
- E-07: `src/node/handler/RestAPI.ts` 363-379行目（ルーティング定義）
- E-08: `src/node/handler/APIHandler.ts` 38行目（パラメータ定義）
- E-09: `src/node/db/API.ts` 47行目（関数エクスポート）
- E-10: `src/node/db/Pad.ts` 557-615行目（remove関数実装）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 5行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントはDELETE /api/2/groups | E-07 | ○ |
| C-02 | groupIDが必須パラメータ | E-08 | ○ |
| C-03 | グループ存在確認を行う | E-02 | ○ |
| C-04 | グループ不在時はエラー返却 | E-02 | ○ |
| C-05 | 全パッドを並列で削除 | E-03 | ○ |
| C-06 | 全セッションを並列で削除 | E-04 | ○ |
| C-07 | group2sessionsレコードを削除 | E-05 | ○ |
| C-08 | グループ一覧からエントリを削除（setSub undefined） | E-05 | ○ |
| C-09 | マッピングレコードを削除 | E-05 | ○ |
| C-10 | 最後にグループ本体を削除 | E-06 | ○ |
| C-11 | カスケード削除が行われる | E-03, E-04 | ○ |
| C-12 | 削除順序：パッド→セッション→関連→本体 | E-01 | ○ |
| C-13 | pad.remove()が呼ばれる | E-03, E-10 | ○ |
| C-14 | sessionManager.deleteSession()が呼ばれる | E-04 | ○ |
| C-15 | API.tsでgroupManager.deleteGroupを再エクスポート | E-09 | ○ |
| C-16 | 機能名は「グループ削除」 | E-11 | ○ |
| C-17 | APIバージョン1から利用可能 | E-08 | ○ |
| C-18 | 戻り値はnull | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意: カスケード削除の途中失敗時の整合性について実装確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] deleteGroup関数の実装が設計書と一致しているか確認
- [ ] 削除順序（パッド→セッション→関連→本体）が正しいか確認
- [ ] 並列削除処理が正しく動作するか確認
- [ ] カスケード削除の途中失敗時の挙動を確認
