---
generated_at: 2026-02-10 14:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-トークン検証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` 791-792行目（checkToken関数）
- E-02: `src/node/handler/RestAPI.ts` 859-874行目（エンドポイント定義）
- E-03: `src/node/handler/APIHandler.ts` 72-75行目（バージョン1.2 API定義）
- E-04: `src/node/handler/APIHandler.ts` 175-200行目（認証処理）
- E-05: `src/node/handler/APIKeyHandler.ts` 25-35行目（APIキー読み込み）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 48行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /api/2/checkToken | E-02 | ○ |
| C-02 | checkToken関数は空の非同期関数 | E-01 | ○ |
| C-03 | 実際の認証はAPIHandler.handleで行われる | E-04 | ○ |
| C-04 | APIキー認証はAPIKEY.txt内容と比較 | E-05, E-04 (175-180行目) | ○ |
| C-05 | SSO認証はJWTトークン検証 | E-04 (182-199行目) | ○ |
| C-06 | authorization_codeフローはadmin claim必須 | E-04 (194-195行目) | ○ |
| C-07 | client_credentialsはclient_idチェック | E-04 (190行目) | ○ |
| C-08 | 認証失敗時は401 Unauthorized | E-04 (179, 198行目) | ○ |
| C-09 | バージョン1.2から利用可能 | E-03 | ○ |
| C-10 | 機能一覧で定義されている | E-06 | ○ |
| C-11 | データベース操作なし | E-01 | ○ |
| C-12 | 成功時は{code: 0}を返却 | E-02 | ○ |
| C-13 | 認証情報はheaderまたはqueryから取得 | E-04 (176-177行目) | ○ |
| C-14 | jwtVerifyで署名検証 | E-04 (191-195行目) | ○ |
| C-15 | publicKeyExportedを検証に使用 | E-04 (191行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードベースで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] checkToken関数が本当に何も処理しないことを確認
- [ ] レート制限との併用状況を確認（ブルートフォース対策）
