---
generated_at: 2026-02-10 14:48:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-OAuth2認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/security/OAuth2Provider.ts` 全体（OIDCプロバイダー実装）
- E-02: `src/node/security/OAuth2Provider.ts` 13-63行目（configuration）
- E-03: `src/node/security/OAuth2Provider.ts` 72-78行目（鍵ペア生成）
- E-04: `src/node/security/OAuth2Provider.ts` 80-154行目（Provider初期化）
- E-05: `src/node/security/OAuth2Provider.ts` 157-227行目（インタラクション処理）
- E-06: `src/node/security/OAuth2Provider.ts` 230-259行目（画面表示処理）
- E-07: `src/node/security/OIDCAdapter.ts` 全体（メモリアダプター）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 30-32行目
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 49行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | oidc-providerライブラリを使用 | E-01 (import文) | ○ |
| C-02 | RS256で署名 | E-03 (generateKeyPair('RS256')) | ○ |
| C-03 | findAccountでユーザー検索 | E-02 (15-48行目) | ○ |
| C-04 | settings.usersでユーザー定義 | E-02 (16-21行目) | ○ |
| C-05 | is_adminでadminクレーム設定 | E-02 (32-38行目) | ○ |
| C-06 | TTL設定可能 | E-02 (49行目) | ○ |
| C-07 | openid, profile, email, adminスコープ | E-02 (50-55行目) | ○ |
| C-08 | devInteractions無効 | E-02 (59-61行目) | ○ |
| C-09 | MemoryAdapterをアダプターとして使用 | E-02 (62行目) | ○ |
| C-10 | extraTokenClaimsでカスタムクレーム追加 | E-04 (119-151行目) | ○ |
| C-11 | POST /interaction/:uidでログイン処理 | E-05 (166-189行目) | ○ |
| C-12 | prompt.name === 'login'でログイン判定 | E-05 (166行目) | ○ |
| C-13 | prompt.name === 'consent'で同意判定 | E-05 (191行目) | ○ |
| C-14 | Grant作成・スコープ設定 | E-05 (192-216行目) | ○ |
| C-15 | /views/login.htmlにリダイレクト | E-06 (240-244行目) | ○ |
| C-16 | /views/consent.htmlにリダイレクト | E-06 (246-250行目) | ○ |
| C-17 | LRUCacheで最大500エントリ | E-07 (6行目) | ○ |
| C-18 | 5分のTTL | E-07 (14行目) | ○ |
| C-19 | 画面4,5と関連 | E-08 | ○ |
| C-20 | 機能一覧で定義されている | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードベースで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] メモリベースのアダプターが本番環境で適切か確認
- [ ] クライアントシークレットの安全な管理方法を確認
- [ ] サーバー再起動時のセッション消失の影響を確認
