---
generated_at: 2026-02-10 14:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：49-ログイン認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **管理者Basic認証との関係**：画面6との関連は機能マッピングで示されているが、実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/security/OAuth2Provider.ts` 157-227行目（インタラクション処理）
- E-02: `src/node/security/OAuth2Provider.ts` 167-189行目（ログイン処理）
- E-03: `src/node/security/OAuth2Provider.ts` 230-259行目（画面表示処理）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 29, 33行目
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 50行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /interaction/:uid でログイン処理 | E-01 | ○ |
| C-02 | IncomingFormでフォームデータパース | E-01 (158-161行目) | ○ |
| C-03 | prompt.name === 'login' でログイン判定 | E-02 (167行目) | ○ |
| C-04 | settings.usersからユーザー配列生成 | E-02 (168-177行目) | ○ |
| C-05 | ユーザー名とパスワードで照合 | E-02 (178行目) | ○ |
| C-06 | 認証失敗時にエラーJSON返却 | E-02 (179-182行目) | ○ |
| C-07 | 認証成功時にinteractionFinished呼び出し | E-02 (184-188行目) | ○ |
| C-08 | mergeWithLastSubmission: false | E-02 (187行目) | ○ |
| C-09 | ユーザー名がaccountIdとして使用 | E-02 (186行目) | ○ |
| C-10 | GET /interaction/:uid でログイン画面表示 | E-03 | ○ |
| C-11 | /views/login.html にリダイレクト | E-03 (240-243行目) | ○ |
| C-12 | パスワードは平文で比較 | E-02 (178行目) | ○ |
| C-13 | 画面4（SSOログイン画面）と関連 | E-04 | ○ |
| C-14 | 画面6（管理者ログイン画面）と関連 | E-04 | △ |
| C-15 | 機能一覧で定義されている | E-05 | ○ |
| C-16 | エラーメッセージ "Invalid login" | E-02 (181行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 管理者ログイン画面（画面6）のBasic認証実装詳細
  - 候補：管理画面のBasic認証実装ファイル / Express設定

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - パスワード平文保存のセキュリティ考慮が必要
- 0: 低リスク - 主要なログイン処理ロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードのハッシュ化が将来的に必要か確認
- [ ] ブルートフォース対策の有無を確認
- [ ] 管理者Basic認証とOAuth2ログインの関係を確認
