---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：51-ファイルインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **C-25 ASCII検証ルール**：コード上の動作が複雑で確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/hooks/express/importexport.ts` - Expressルーティング定義
- E-02: `src/node/handler/ImportHandler.ts` - メインインポート処理ロジック
- E-03: `src/node/utils/ImportHtml.ts` - HTML変換処理
- E-04: `src/node/utils/ImportEtherpad.ts` - Etherpad形式復元処理
- E-05: `src/node/utils/LibreOffice.ts` - LibreOffice変換処理
- E-06: `src/node/handler/PadMessageHandler.ts` - クライアント通知処理
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイルインポートはPOST /p/:pad/importで受け付ける | E-01 (74-75行目) | ○ |
| C-02 | 対応形式は.txt/.doc/.docx/.pdf/.odt/.html/.htm/.etherpad/.rtf | E-02 (119-120行目) | ○ |
| C-03 | Formidableでファイルパースを行う | E-02 (29, 91-95行目) | ○ |
| C-04 | ファイルサイズ制限はsettings.importMaxFileSizeで設定 | E-02 (94行目) | ○ |
| C-05 | レート制限はexpress-rate-limitで実装 | E-01 (11, 16-25行目) | ○ |
| C-06 | セキュリティチェックはsecurityManager.checkAccessで実行 | E-01 (79-80行目) | ○ |
| C-07 | 書き込み権限チェックはwebaccess.userCanModifyで実行 | E-01 (81行目) | ○ |
| C-08 | .etherpad形式は直接DBにインポート | E-02 (146-157行目) | ○ |
| C-09 | .etherpad形式は10リビジョン以上のパッドには拒否 | E-02 (150-152行目) | ○ |
| C-10 | LibreOfficeはsettings.sofficeで有効化 | E-02 (68-71行目) | ○ |
| C-11 | AbiWordはsettings.abiwordで有効化 | E-02 (63-65行目) | ○ |
| C-12 | LibreOffice変換はキュー処理で同時実行数1 | E-05 (82行目) | ○ |
| C-13 | LibreOffice変換タイムアウトは120秒 | E-05 (64行目) | ○ |
| C-14 | 未知拡張子はallowUnknownFileEndsでtxt処理可能 | E-02 (123-136行目) | ○ |
| C-15 | HTML変換はimportHtml.setPadHTMLで実行 | E-02 (213行目), E-03 (28行目) | ○ |
| C-16 | テキスト設定はpad.setTextで実行 | E-02 (218行目) | ○ |
| C-17 | クライアント通知はpadMessageHandler.updatePadClientsで実行 | E-02 (232行目), E-06 | ○ |
| C-18 | 一時ファイルはos.tmpdir()に保存 | E-02 (73行目) | ○ |
| C-19 | 処理完了後に一時ファイル削除 | E-02 (235-236行目) | ○ |
| C-20 | Windows環境では100ms待機処理あり | E-02 (204-206行目) | ○ |
| C-21 | JSONレスポンスでcode/message/dataを返却 | E-02 (263行目) | ○ |
| C-22 | エラー時httpStatusは400または500 | E-02 (259行目) | ○ |
| C-23 | 画面機能マッピングでパッド編集画面の補助機能 | E-07 (11行目) | ○ |
| C-24 | 機能一覧でNo.51として登録 | E-08 (52行目) | ○ |
| C-25 | 非ASCII文字のみのファイルはコンバータ未使用時拒否 | E-02 (180-191行目) | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: コードでは「ASCII以外の文字が含まれる場合」の検証だが、設計書での記載と微妙に異なる可能性。実際のロジック（185行目のisAscii判定）を詳細確認が必要
  - 候補：E-02の該当箇所の再確認 / テストケースの確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードと一致
- 1: 中リスク - ASCII検証ルールの記載精度

## 6) レビュアーチェックリスト（最小）
- [ ] C-25のASCII検証ロジックがソースコードと一致しているか確認
- [ ] レート制限のデフォルト値がsettings.jsonで確認できるか
- [ ] 実際のインポート操作でエラーメッセージが設計書と一致するか
