---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：52-テキストエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/hooks/express/importexport.ts` - Expressルーティング定義
- E-02: `src/node/handler/ExportHandler.ts` - エクスポートハンドラ
- E-03: `src/node/utils/ExportTxt.ts` - テキスト変換処理
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テキストエクスポートはGET /p/:pad/export/txtで受け付ける | E-01 (28-29行目) | ○ |
| C-02 | リビジョン指定はGET /p/:pad/:rev/export/txtで可能 | E-01 (28行目) | ○ |
| C-03 | 対応形式チェックでtxtが含まれる | E-01 (31行目) | ○ |
| C-04 | hasPadAccessでアクセス権チェック | E-01 (52行目) | ○ |
| C-05 | 読み取り専用IDの場合は実パッドIDを取得 | E-01 (56-58行目) | ○ |
| C-06 | パッド存在確認はpadManager.doesPadExists | E-01 (61行目) | ○ |
| C-07 | リビジョン検証はcheckValidRev | E-02 (64行目) | ○ |
| C-08 | exporttxt.getPadTXTDocumentでテキスト生成 | E-02 (73行目) | ○ |
| C-09 | res.attachmentでファイル名設定 | E-02 (59行目) | ○ |
| C-10 | hookでファイル名カスタマイズ可能 | E-02 (51-56行目) | ○ |
| C-11 | 箇条書きは「* 」プレフィックス | E-03 (205-206行目) | ○ |
| C-12 | 番号リストは「N. 」形式 | E-03 (253行目) | ○ |
| C-13 | ネストはタブ文字でインデント | E-03 (218行目) | ○ |
| C-14 | 階層番号は「1.1. 」形式 | E-03 (244-252行目) | ○ |
| C-15 | 書式属性は無視される | E-03 (52行目のprops定義) | ○ |
| C-16 | 画面機能マッピングでパッド編集画面の補助機能 | E-04 (12行目) | ○ |
| C-17 | 画面機能マッピングでタイムスライダー画面の補助機能 | E-04 (24行目) | ○ |
| C-18 | 機能一覧でNo.52として登録 | E-05 (53行目) | ○ |
| C-19 | レート制限はexpress-rate-limitで実装 | E-01 (16-25行目) | ○ |
| C-20 | CORSヘッダーが設定される | E-01 (50行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のエクスポート操作でリスト表現が設計書通りか確認
- [ ] 大きなパッドでのパフォーマンスが許容範囲内か確認
