---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-HTMLエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/hooks/express/importexport.ts` - Expressルーティング定義
- E-02: `src/node/handler/ExportHandler.ts` - エクスポートハンドラ
- E-03: `src/node/utils/ExportHtml.ts` - HTML変換処理
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTMLエクスポートはGET /p/:pad/export/htmlで受け付ける | E-01 (28-29行目) | ○ |
| C-02 | リビジョン指定はGET /p/:pad/:rev/export/htmlで可能 | E-01 (28行目) | ○ |
| C-03 | 対応形式チェックでhtmlが含まれる | E-01 (31行目) | ○ |
| C-04 | hasPadAccessでアクセス権チェック | E-01 (52行目) | ○ |
| C-05 | exporthtml.getPadHTMLDocumentでHTML生成 | E-02 (77行目) | ○ |
| C-06 | exportHTMLSendフックで最終調整 | E-02 (84-85行目) | ○ |
| C-07 | 書式タグ: bold→strong, italic→em等 | E-03 (51-52行目) | ○ |
| C-08 | 見出しタグ: heading1→h1, heading2→h2 | E-03 (51-52行目) | ○ |
| C-09 | リスト変換: 箇条書き→ul/li | E-03 (408行目) | ○ |
| C-10 | リスト変換: 番号付き→ol/li | E-03 (403-405行目) | ○ |
| C-11 | リンク変換: rel="noreferrer noopener"付与 | E-03 (286行目) | ○ |
| C-12 | 空白処理: 連続スペースはnbsp変換 | E-03 (503-549行目) | ○ |
| C-13 | HTML特殊文字エスケープ | E-03 (261行目) Security.escapeHTML | ○ |
| C-14 | exportHtmlAdditionalTagsフックでカスタムタグ追加 | E-03 (56-60行目) | ○ |
| C-15 | exportHtmlAdditionalTagsWithDataフックでdata属性付きspan | E-03 (64-69行目) | ○ |
| C-16 | stylesForExportフックでカスタムCSS追加 | E-03 (484行目) | ○ |
| C-17 | exportHTMLAdditionalContentフックで追加コンテンツ | E-03 (491-493行目) | ○ |
| C-18 | eejs.requireでテンプレート適用 | E-03 (495-499行目) | ○ |
| C-19 | 画面機能マッピングでパッド編集画面の補助機能 | E-04 (13行目) | ○ |
| C-20 | 画面機能マッピングでタイムスライダー画面の補助機能 | E-04 (25行目) | ○ |
| C-21 | 機能一覧でNo.53として登録 | E-05 (54行目) | ○ |
| C-22 | 特殊文字（Unicode 12）は除去 | E-03 (259行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のエクスポート操作で書式タグが正しく変換されるか確認
- [ ] リンクのrel属性が正しく付与されるか確認
- [ ] プラグインフックが期待通り動作するか確認
