---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-Etherpadエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/hooks/express/importexport.ts` - Expressルーティング定義
- E-02: `src/node/handler/ExportHandler.ts` - エクスポートハンドラ
- E-03: `src/node/utils/ExportEtherpad.ts` - Etherpad形式エクスポート処理
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Etherpadエクスポートはtype=etherpadで処理 | E-02 (69行目) | ○ |
| C-02 | exportEtherpad.getPadRawでデータ取得 | E-02 (70行目) | ○ |
| C-03 | 読み取り専用IDでアクセス時は出力にreadOnlyIdを使用 | E-03 (25行目) | ○ |
| C-04 | 著者のpadIDsを単一パッドID文字列に変換 | E-03 (48行目) | ○ |
| C-05 | リビジョンは0からheadまで出力 | E-03 (52行目) | ○ |
| C-06 | チャットは0からchatHeadまで出力 | E-03 (53行目) | ○ |
| C-07 | exportEtherpadAdditionalContentフックでプラグインプレフィックス取得 | E-03 (28行目) | ○ |
| C-08 | exportEtherpadフックで最終調整 | E-03 (58-62行目) | ○ |
| C-09 | Streamでバッチ処理（100件ずつ） | E-03 (57行目) | ○ |
| C-10 | buffer(99)で非同期バッファリング | E-03 (57行目) | ○ |
| C-11 | pad:{padId}キーでパッドメインデータ出力 | E-03 (56行目) | ○ |
| C-12 | pad:{padId}:revs:{n}キーでリビジョン出力 | E-03 (52行目) | ○ |
| C-13 | pad:{padId}:chat:{n}キーでチャット出力 | E-03 (53行目) | ○ |
| C-14 | globalAuthor:{authorId}キーで著者情報出力 | E-03 (45行目) | ○ |
| C-15 | 著者が存在しない場合はundefinedを返す | E-03 (47行目) | ○ |
| C-16 | プラグインデータはdb.findKeysで検索 | E-03 (34行目) | ○ |
| C-17 | getAllAuthorsでパッドの著者一覧取得 | E-03 (44行目) | ○ |
| C-18 | 画面機能マッピングでパッド編集画面の補助機能 | E-04 (14行目) | ○ |
| C-19 | 画面機能マッピングでタイムスライダー画面の補助機能 | E-04 (26行目) | ○ |
| C-20 | 機能一覧でNo.54として登録 | E-05 (55行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 大量リビジョンのパッドでエクスポートが正常に完了するか確認
- [ ] エクスポートしたデータをインポートして履歴が復元されるか確認
- [ ] プラグイン追加データが正しくエクスポートされるか確認
