---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-ドキュメント変換エクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/hooks/express/importexport.ts` - Expressルーティング定義
- E-02: `src/node/handler/ExportHandler.ts` - エクスポートハンドラ
- E-03: `src/node/utils/LibreOffice.ts` - LibreOffice変換処理
- E-04: `src/node/utils/Settings.ts` - 設定管理
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 対応形式はpdf, doc, odt | E-01 (31行目) | ○ |
| C-02 | コンバータ未設定時はエラーメッセージ表示 | E-01 (38-48行目) | ○ |
| C-03 | exportAvailable()でコンバータ利用可能性チェック | E-01 (38行目) | ○ |
| C-04 | HTML生成後に一時ファイル保存 | E-02 (93行目) | ○ |
| C-05 | exportConvertフックでプラグイン変換可能 | E-02 (102行目) | ○ |
| C-06 | soffice設定時はLibreOffice使用 | E-02 (107行目) | ○ |
| C-07 | abiword設定時はAbiWord使用 | E-02 (108行目) | ○ |
| C-08 | sofficeが優先される | E-02 (106-109行目の条件式) | ○ |
| C-09 | res.sendFileでファイル送信 | E-02 (114行目) | ○ |
| C-10 | 一時ファイル削除処理 | E-02 (117, 124行目) | ○ |
| C-11 | Windows環境で100ms待機 | E-02 (120-122行目) | ○ |
| C-12 | LibreOfficeは--headlessオプション | E-03 (40行目) | ○ |
| C-13 | LibreOfficeは--invisibleオプション | E-03 (41行目) | ○ |
| C-14 | LibreOfficeは--nolockcheckオプション | E-03 (43行目) | ○ |
| C-15 | 変換タイムアウトは120秒 | E-03 (64行目) | ○ |
| C-16 | タイムアウト時はプロセスkill | E-03 (63行目) | ○ |
| C-17 | キュー処理で同時実行数1 | E-03 (82行目) | ○ |
| C-18 | doc形式は2段階変換（odt経由） | E-03 (110-113行目) | ○ |
| C-19 | PDF用にDraw変換タイプ使用 | E-03 (103行目) | ○ |
| C-20 | 画面機能マッピングでパッド編集画面の補助機能 | E-05 (15行目) | ○ |
| C-21 | 画面機能マッピングでタイムスライダー画面の補助機能 | E-05 (27行目) | ○ |
| C-22 | 機能一覧でNo.55として登録 | E-06 (56行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] LibreOfficeがインストールされた環境でpdf/doc/odtエクスポートが動作するか確認
- [ ] タイムアウト処理が正しく機能するか確認
- [ ] 大きなドキュメントの変換でメモリ使用量が問題ないか確認
