---
generated_at: 2026-02-10 13:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：61-プラグイン管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **キャッシュ有効期限10分**：コード中は60*10秒=600秒であり正確だが、設定で変更可能かは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/hooks/express/adminplugins.ts` - Socket.IOハンドラ実装
- E-02: `src/static/js/pluginfw/installer.ts` - install/uninstall/search関数
- E-03: `src/static/js/pluginfw/LinkInstaller.ts` - live-plugin-manager統合
- E-04: `src/static/js/pluginfw/plugins.ts` - プラグインロード処理
- E-05: `admin/src/pages/HomePage.tsx` - フロントエンドUI実装
- E-06: `admin/src/pages/Plugin.ts` - 型定義
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理者権限(is_admin)が必要 | E-01 (21-22行目) | ○ |
| C-02 | Socket.IOで通信 | E-01, E-05 | ○ |
| C-03 | プラグイン名はep_プレフィックス | E-02 (194行目) | ○ |
| C-04 | live-plugin-managerを使用 | E-03 (1行目, import) | ○ |
| C-05 | インストール後にplugins.update()実行 | E-02 (30-36行目) | ○ |
| C-06 | reloadSettings()が呼ばれる | E-02 (33行目) | ○ |
| C-07 | restartServerフックが呼ばれる | E-02 (35行目) | ○ |
| C-08 | キャッシュ有効期限600秒 | E-01 (27行目), E-02 (89行目) | ○ |
| C-09 | semver.gtで更新判定 | E-01 (38行目) | ○ |
| C-10 | installed_plugins.jsonに永続化 | E-02 (28, 132-144行目) | ○ |
| C-11 | 検索でソート・フィルタリング可能 | E-01 (86-100行目) | ○ |
| C-12 | シンボリックリンクで依存管理 | E-03 (204-220行目) | ○ |
| C-13 | getInstalledでプラグイン一覧取得 | E-01 (47-59行目) | ○ |
| C-14 | checkUpdatesで更新確認 | E-01 (62-74行目) | ○ |
| C-15 | ep_etherpad-liteはアンインストール不可 | E-05 (185行目, disabled判定) | ○ |
| C-16 | プラグイン管理画面(No.7)と関連 | E-08 | ○ |
| C-17 | ヘルプ/情報画面(No.9)と関連 | E-08 | ○ |
| C-18 | 名前空間は/pluginfw/installer | E-01 (18行目) | ○ |
| C-19 | 検索結果からインストール済みを除外 | E-01 (92行目) | ○ |
| C-20 | エラー時にresults:searcherror送信 | E-01 (98行目) | ○ |
| C-21 | updateServerからプラグイン情報取得 | E-02 (176行目) | ○ |
| C-22 | axios使用でHTTP通信 | E-02 (5行目, import) | ○ |
| C-23 | User-AgentにEtherpadバージョン含む | E-02 (38-40行目) | ○ |
| C-24 | 依存関係の削除も管理 | E-03 (77-85, 87-111行目) | ○ |
| C-25 | パフォーマンス要件2秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（2秒以内）について明確な仕様書やテストケースが見つからない
  - 候補：performance tests / SLA documentation / requirements.md

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に高い信頼度

## 6) レビュアーチェックリスト（最小）
- [ ] プラグインインストール後のサーバー再起動動作を実機で確認
- [ ] ep_etherpad-liteのアンインストール防止が正しく動作するか確認
- [ ] 大量プラグインがある場合の検索パフォーマンスを確認
