---
generated_at: 2026-02-10 13:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-統計情報取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/hooks/express/specialpages.ts` - HTTPエンドポイント定義
- E-02: `src/node/stats.ts` - measured-core統計
- E-03: `src/node/prometheus.ts` - Prometheusメトリクス
- E-04: `src/node/db/DB.ts` - ueberDBメトリクス登録
- E-05: `src/node/utils/Settings.ts` - enableMetrics設定
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | enableMetrics設定でエンドポイント制御 | E-01 (37行目), E-05 (413行目) | ○ |
| C-02 | /statsでJSON形式統計取得 | E-01 (38-40行目) | ○ |
| C-03 | /stats/prometheusでPrometheus形式取得 | E-01 (42-46行目) | ○ |
| C-04 | measured-core使用 | E-02 (3-5行目) | ○ |
| C-05 | stats.toJSON()で統計取得 | E-01 (39行目), E-02 | ○ |
| C-06 | prom-client使用 | E-03 (1行目, import) | ○ |
| C-07 | ueberdb_statsメトリクス | E-03 (7-12行目) | ○ |
| C-08 | etherpad_total_usersメトリクス | E-03 (14-18行目) | ○ |
| C-09 | etherpad_active_padsメトリクス | E-03 (20-24行目) | ○ |
| C-10 | デフォルトメトリクス収集 | E-03 (26行目) | ○ |
| C-11 | getActivePadCountFromSessionInfos使用 | E-03 (33行目) | ○ |
| C-12 | getTotalActiveUsers使用 | E-03 (34行目) | ○ |
| C-13 | db.metrics取得 | E-03 (29-32行目), E-04 (42-47行目) | ○ |
| C-14 | プラグイン管理画面と連携 | E-07 | ○ |
| C-15 | ヘルプ/情報画面と連携 | E-07 | ○ |
| C-16 | コミュニケーション画面と連携 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] enableMetrics=trueの場合に/statsエンドポイントが有効か確認
- [ ] Prometheus形式のメトリクスがPrometheusサーバーで正しく取得できるか確認
- [ ] ueberDBメトリクスが正しく収集されているか確認
