---
generated_at: 2026-02-10 14:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：68-グループデータ永続化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/GroupManager.ts` - グループ管理モジュール
- E-02: `src/node/db/PadManager.ts` - パッド管理モジュール
- E-03: `src/node/db/SessionManager.ts` - セッション管理モジュール
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createGroup関数 | E-01 (96-104行目) | ○ |
| C-02 | グループIDはg.+16文字 | E-01 (97行目) | ○ |
| C-03 | group:{groupID}保存 | E-01 (98行目) | ○ |
| C-04 | pads/mappings初期化 | E-01 (98行目) | ○ |
| C-05 | groups更新 | E-01 (102行目) | ○ |
| C-06 | createGroupIfNotExistsFor関数 | E-01 (111-127行目) | ○ |
| C-07 | mapper2groupから検索 | E-01 (115行目) | ○ |
| C-08 | マッパー検証（文字列型） | E-01 (112-114行目) | ○ |
| C-09 | createGroupPad関数 | E-01 (137-163行目) | ○ |
| C-10 | パッドID形式（groupID$padName） | E-01 (139行目) | ○ |
| C-11 | グループ存在確認 | E-01 (142-146行目) | ○ |
| C-12 | パッド重複確認 | E-01 (148-153行目) | ○ |
| C-13 | グループのpadsに追加 | E-01 (160行目) | ○ |
| C-14 | deleteGroup関数 | E-01 (45-78行目) | ○ |
| C-15 | 関連パッド削除 | E-01 (54-58行目) | ○ |
| C-16 | 関連セッション削除 | E-01 (61-65行目) | ○ |
| C-17 | listAllGroups関数 | E-01 (32-38行目) | ○ |
| C-18 | listPads関数 | E-01 (170-183行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] グループIDが正しく"g."+16文字形式で生成されるか確認
- [ ] グループ削除時に関連パッド・セッションが正しく削除されるか確認
- [ ] createGroupIfNotExistsForでマッパーが正しく動作するか確認
- [ ] グループパッドIDが正しく"groupID$padName"形式になるか確認
