---
generated_at: 2026-02-10 14:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：75-国際化対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/node/hooks/i18n.ts` 6行目 - languages4translatewikiインポート
- E-02: `src/node/hooks/i18n.ts` 16-104行目 - getAllLocales関数
- E-03: `src/node/hooks/i18n.ts` 22-40行目 - extractLangs内部関数
- E-04: `src/node/hooks/i18n.ts` 35行目 - languages.isValid()での言語コード検証
- E-05: `src/node/hooks/i18n.ts` 43行目 - コアロケール読み込み
- E-06: `src/node/hooks/i18n.ts` 46-50行目 - プラグインロケール読み込み
- E-07: `src/node/hooks/i18n.ts` 53-67行目 - ファイルマージ処理
- E-08: `src/node/hooks/i18n.ts` 74-101行目 - customLocaleStrings適用
- E-09: `src/node/hooks/i18n.ts` 108-114行目 - getAvailableLangs関数
- E-10: `src/node/hooks/i18n.ts` 117-123行目 - generateLocaleIndex関数
- E-11: `src/node/hooks/i18n.ts` 126-149行目 - expressPreSession hook
- E-12: `src/node/hooks/i18n.ts` 132-142行目 - /locales/:locale エンドポイント
- E-13: `src/node/hooks/i18n.ts` 144-148行目 - /locales.json エンドポイント
- E-14: `src/node/hooks/i18n.ts` 136行目 - Cache-Controlヘッダー設定
- E-15: `src/node/hooks/i18n.ts` 140行目 - 404レスポンス
- E-16: `src/static/js/vendors/html10n.ts` 6-52行目 - Html10nクラス基本構造
- E-17: `src/static/js/vendors/html10n.ts` 17行目 - RTL言語リスト
- E-18: `src/static/js/vendors/html10n.ts` 22-46行目 - pluralマクロ
- E-19: `src/static/js/vendors/html10n.ts` 72-200行目以降 - getPluralRules関数
- E-20: `src/locales/en.json` - 英語ロケールファイル
- E-21: `src/locales/ja.json` - 日本語ロケールファイル（存在確認）
- E-22: `src/node/utils/Settings.ts` 281行目 - customLocaleStrings型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | languages4translatewikiで言語コード検証 | E-01, E-04 | ○ |
| C-02 | src/locales/配下のJSONファイルを読み込み | E-05 | ○ |
| C-03 | プラグインのlocales/配下も読み込み | E-06 | ○ |
| C-04 | 同一言語のファイルをマージ | E-07 | ○ |
| C-05 | customLocaleStringsで上書き | E-08, E-22 | ○ |
| C-06 | /locales/:localeでJSON配信 | E-12 | ○ |
| C-07 | /locales.jsonでインデックス配信 | E-13 | ○ |
| C-08 | 無効な言語コードは404 | E-15 | ○ |
| C-09 | Cache-Controlヘッダー設定 | E-14 | ○ |
| C-10 | html10nでクライアント側翻訳 | E-16 | ○ |
| C-11 | RTL言語を識別 | E-17 | ○ |
| C-12 | 複数形ルールをサポート | E-18, E-19 | ○ |
| C-13 | getAllLocales関数は16-104行目 | E-02 | ○ |
| C-14 | extractLangs関数は22-40行目 | E-03 | ○ |
| C-15 | getAvailableLangs関数は108-114行目 | E-09 | ○ |
| C-16 | generateLocaleIndex関数は117-123行目 | E-10 | ○ |
| C-17 | expressPreSession hookは126-149行目 | E-11 | ○ |
| C-18 | /locales/:localeエンドポイントは132-142行目 | E-12 | ○ |
| C-19 | /locales.jsonエンドポイントは144-148行目 | E-13 | ○ |
| C-20 | Html10nクラスは6-52行目 | E-16 | ○ |
| C-21 | pluralマクロは22-46行目 | E-18 | ○ |
| C-22 | getPluralRulesは72行目以降 | E-19 | ○ |
| C-23 | プラグインロケールがコアを上書き | E-06, E-07 | ○ |
| C-24 | customLocaleStringsが最優先 | E-08 | ○ |
| C-25 | 英語をベースにインデックス生成 | E-10 | ○ |
| C-26 | シンボリックリンクは除外 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり
- 翻訳の品質は外部のTranslateWikiに依存

## 6) レビュアーチェックリスト（最小）
- [ ] customLocaleStringsの形式が正しいか
- [ ] プラグインのロケールファイルが正しく読み込まれているか
- [ ] RTL言語での表示が正しく動作するか
- [ ] 複数形の表示が各言語で正しく動作するか
