---
generated_at: 2026-02-10 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-パッドコピー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` 615-618行目（copyPad関数実装）
- E-02: `src/node/db/Pad.ts` 403-454行目（copy関数実装）
- E-03: `src/node/db/Pad.ts` 410行目（saveToDatabase）
- E-04: `src/node/db/Pad.ts` 413行目（checkIfGroupExistAndReturnIt）
- E-05: `src/node/db/Pad.ts` 416行目（removePadIfForceIsTrueAndAlreadyExist）
- E-06: `src/node/db/Pad.ts` 418-421行目（copyRecord関数）
- E-07: `src/node/db/Pad.ts` 423-432行目（ジェネレータ）
- E-08: `src/node/db/Pad.ts` 433行目（batch処理）
- E-09: `src/node/db/Pad.ts` 456-469行目（checkIfGroupExistAndReturnIt実装）
- E-10: `src/node/db/Pad.ts` 471-492行目（removePadIfForceIsTrueAndAlreadyExist実装）
- E-11: `src/node/handler/RestAPI.ts` 1035-1061行目（ルーティング定義）
- E-12: `src/node/handler/APIHandler.ts` 97行目（パラメータ定義）
- E-13: `docs/code-to-docs/機能一覧/機能一覧.csv` 10行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントはPOST /api/2/pads/copypad | E-11 | ○ |
| C-02 | sourceID, destinationID, forceがパラメータ | E-12 | ○ |
| C-03 | getPadSafeでコピー元パッド取得 | E-01 | ○ |
| C-04 | pad.copyでコピー実行 | E-01 | ○ |
| C-05 | saveToDatabaseでフラッシュ | E-03 | ○ |
| C-06 | checkIfGroupExistAndReturnItでグループ確認 | E-04, E-09 | ○ |
| C-07 | $を含むdestinationIDはグループパッド | E-09 | ○ |
| C-08 | グループ不在時はエラー | E-09 | ○ |
| C-09 | force=trueで既存パッド削除 | E-05, E-10 | ○ |
| C-10 | force=falseで既存パッドありはエラー | E-10 | ○ |
| C-11 | copyRecord関数でレコードコピー | E-06 | ○ |
| C-12 | ジェネレータで本体・revs・chatをコピー | E-07 | ○ |
| C-13 | batch(100).buffer(99)でバッチ処理 | E-08 | ○ |
| C-14 | copyAuthorInfoToDestinationPadで著者コピー | E-02 | ○ |
| C-15 | グループパッドはグループに登録 | E-02 | ○ |
| C-16 | padCopyフックが実行される | E-02 | ○ |
| C-17 | 機能名は「パッドコピー」 | E-13 | ○ |
| C-18 | APIバージョン1.2.9から利用可能 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能
- 注意: 大量リビジョンのコピー時のパフォーマンスを実地検証推奨

## 6) レビュアーチェックリスト（最小）
- [ ] copy関数の実装が設計書と一致しているか確認
- [ ] ジェネレータによるコピー対象生成が正しいか確認
- [ ] バッチ処理のサイズと並列度が適切か確認
- [ ] force=true時の削除処理が正しいか確認
