---
generated_at: 2026-02-10 12:55:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/templates/index.html` - トップページのHTMLテンプレート
- E-02: `src/templates/pad.html` - パッド編集画面のHTMLテンプレート
- E-03: `src/templates/timeslider.html` - タイムスライダー画面のHTMLテンプレート
- E-04: `ui/login.html` - SSO ログイン画面のHTML
- E-05: `ui/consent.html` - OAuth2同意画面のHTML
- E-06: `admin/src/pages/LoginScreen.tsx` - 管理者ログイン画面のReactコンポーネント
- E-07: `admin/src/pages/HomePage.tsx` - プラグイン管理画面のReactコンポーネント
- E-08: `admin/src/pages/SettingsPage.tsx` - 設定管理画面のReactコンポーネント
- E-09: `admin/src/pages/HelpPage.tsx` - ヘルプ/情報画面のReactコンポーネント
- E-10: `admin/src/pages/PadPage.tsx` - パッド管理画面のReactコンポーネント
- E-11: `admin/src/pages/ShoutPage.tsx` - コミュニケーション画面のReactコンポーネント
- E-12: `src/node/hooks/express/specialpages.ts` - ルーティング設定ファイル
- E-13: `admin/src/main.tsx` - 管理画面のルーティング設定
- E-14: `admin/src/App.tsx` - 管理画面のメインアプリケーション構成

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トップページ（/）が存在し、パッド作成機能を提供 | E-01, E-12 | ○ |
| C-02 | パッド編集画面（/p/:pad）が存在し、リアルタイム共同編集機能を提供 | E-02, E-12 | ○ |
| C-03 | タイムスライダー画面（/p/:pad/timeslider）が存在し、履歴確認機能を提供 | E-03, E-12 | ○ |
| C-04 | SSO ログイン画面が存在し、OAuth2認証に使用される | E-04 | ○ |
| C-05 | OAuth2同意画面が存在する | E-05 | ○ |
| C-06 | 管理者ログイン画面（/admin/login）が存在する | E-06, E-13 | ○ |
| C-07 | プラグイン管理画面（/admin/plugins）が存在し、プラグインのインストール/アンインストール機能を提供 | E-07, E-13 | ○ |
| C-08 | 設定管理画面（/admin/settings）が存在し、settings.jsonの編集・サーバー再起動機能を提供 | E-08, E-13 | ○ |
| C-09 | ヘルプ/情報画面（/admin/help）が存在し、バージョン情報・プラグイン・フック情報を表示 | E-09, E-13 | ○ |
| C-10 | パッド管理画面（/admin/pads）が存在し、パッドの一覧・検索・削除・作成機能を提供 | E-10, E-13 | ○ |
| C-11 | コミュニケーション画面（/admin/shout）が存在し、全ユーザーへのメッセージ送信機能を提供 | E-11, E-13, E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - 全ての画面について、ソースコードから根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認できた
- 注意点：OAuth2/OIDC認証画面（ui/login.html, ui/consent.html）は設定によって有効/無効が変わる

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧の各画面が実際のアプリケーションに存在するか確認
- [ ] URLパスが正しいか確認（特に /p/:pad 形式のパラメータパス）
- [ ] 管理画面のルーティング（/admin/*）が正しくマッピングされているか確認
- [ ] OAuth2認証画面が設定に応じて正しく表示されるか確認
- [ ] 画面遷移図のフローが実際の動作と一致するか確認
