# 画面遷移図

## 概要

このドキュメントは、Etherpad Liteの画面遷移を示します。

## エンドユーザー向け画面遷移

```mermaid
flowchart TD
    subgraph エンドユーザー
        TOP[トップページ<br>/]
        PAD[パッド編集画面<br>/p/:pad]
        TIMESLIDER[タイムスライダー画面<br>/p/:pad/timeslider]
    end

    TOP -->|新規パッド作成| PAD
    TOP -->|パッド名入力して開く| PAD
    PAD -->|履歴ボタン| TIMESLIDER
    TIMESLIDER -->|パッドに戻る| PAD
    PAD -->|別のパッドへ| TOP
```

## 認証画面遷移（OAuth2/OIDC）

```mermaid
flowchart TD
    subgraph 認証フロー
        LOGIN[SSO ログイン画面<br>/interaction/:uid]
        CONSENT[同意画面<br>/interaction/:uid]
        CALLBACK[認証コールバック]
    end

    LOGIN -->|認証成功| CONSENT
    CONSENT -->|同意| CALLBACK
    CALLBACK -->|リダイレクト| PAD[パッド編集画面]
```

## 管理画面遷移

```mermaid
flowchart TD
    subgraph 管理画面
        ADMIN_LOGIN[管理者ログイン画面<br>/admin/login]
        PLUGINS[プラグイン管理画面<br>/admin/plugins]
        SETTINGS[設定管理画面<br>/admin/settings]
        HELP[ヘルプ/情報画面<br>/admin/help]
        PADS[パッド管理画面<br>/admin/pads]
        SHOUT[コミュニケーション画面<br>/admin/shout]
    end

    ADMIN_LOGIN -->|認証成功| PLUGINS
    PLUGINS <-->|サイドメニュー| SETTINGS
    PLUGINS <-->|サイドメニュー| HELP
    PLUGINS <-->|サイドメニュー| PADS
    PLUGINS <-->|サイドメニュー| SHOUT
    SETTINGS <-->|サイドメニュー| HELP
    SETTINGS <-->|サイドメニュー| PADS
    SETTINGS <-->|サイドメニュー| SHOUT
    HELP <-->|サイドメニュー| PADS
    HELP <-->|サイドメニュー| SHOUT
    PADS <-->|サイドメニュー| SHOUT

    PADS -->|パッドを開く| PAD_EDIT[パッド編集画面<br>/p/:pad]
```

## 全体画面遷移図

```mermaid
flowchart TD
    subgraph パブリック
        TOP[トップページ<br>/]
        PAD[パッド編集画面<br>/p/:pad]
        TIMESLIDER[タイムスライダー画面<br>/p/:pad/timeslider]
    end

    subgraph 認証
        SSO_LOGIN[SSO ログイン画面]
        SSO_CONSENT[同意画面]
    end

    subgraph 管理画面
        ADMIN_LOGIN[管理者ログイン画面<br>/admin/login]
        ADMIN_PLUGINS[プラグイン管理<br>/admin/plugins]
        ADMIN_SETTINGS[設定管理<br>/admin/settings]
        ADMIN_HELP[ヘルプ/情報<br>/admin/help]
        ADMIN_PADS[パッド管理<br>/admin/pads]
        ADMIN_SHOUT[コミュニケーション<br>/admin/shout]
    end

    TOP -->|パッド作成/開く| PAD
    PAD -->|履歴表示| TIMESLIDER
    TIMESLIDER -->|戻る| PAD

    PAD -.->|認証が必要な場合| SSO_LOGIN
    SSO_LOGIN --> SSO_CONSENT
    SSO_CONSENT --> PAD

    ADMIN_LOGIN --> ADMIN_PLUGINS
    ADMIN_PLUGINS <--> ADMIN_SETTINGS
    ADMIN_PLUGINS <--> ADMIN_HELP
    ADMIN_PLUGINS <--> ADMIN_PADS
    ADMIN_PLUGINS <--> ADMIN_SHOUT
    ADMIN_PADS -->|パッドを開く| PAD
```

## 画面間の主要な遷移パターン

### 1. パッド作成フロー
1. トップページ（/）にアクセス
2. 「新規パッド作成」ボタンをクリック、またはパッド名を入力
3. パッド編集画面（/p/:pad）へ遷移

### 2. パッド履歴確認フロー
1. パッド編集画面（/p/:pad）でツールバーの履歴ボタンをクリック
2. タイムスライダー画面（/p/:pad/timeslider）へ遷移
3. スライダーで任意の時点の内容を確認

### 3. 管理画面アクセスフロー
1. /admin にアクセス
2. 認証情報がない場合、管理者ログイン画面へリダイレクト
3. 認証成功後、プラグイン管理画面（/admin/plugins）へ遷移
4. サイドメニューから各管理画面へ移動可能

### 4. OAuth2認証フロー（設定されている場合）
1. 認証が必要なパッドへアクセス
2. SSO ログイン画面へリダイレクト
3. 認証成功後、同意画面へ遷移
4. 同意後、元のパッドへリダイレクト
