---
generated_at: 2026-02-10 12:30:00
metrics:
  claims_total: 47
  claims_with_evidence: 45
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：45 / 47、根拠なし：2
- 優先レビュー（高）
  1. **パッド編集画面-リビジョン数取得（API連携）**：コード上でSocket.IOイベントとして明示的に確認できず
  2. **タイムスライダー画面-リビジョン変更セット取得**：具体的なSocket.IOメッセージ名の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `src/templates/index.html`
- E-04: `src/templates/pad.html`
- E-05: `src/templates/timeslider.html`
- E-06: `ui/login.html`
- E-07: `ui/consent.html`
- E-08: `admin/src/pages/LoginScreen.tsx`
- E-09: `admin/src/pages/HomePage.tsx`
- E-10: `admin/src/pages/SettingsPage.tsx`
- E-11: `admin/src/pages/HelpPage.tsx`
- E-12: `admin/src/pages/PadPage.tsx`
- E-13: `admin/src/pages/ShoutPage.tsx`
- E-14: `src/node/handler/PadMessageHandler.ts`
- E-15: `src/node/handler/ImportHandler.ts`
- E-16: `src/node/handler/ExportHandler.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トップページ-パッド作成（主機能） | E-01, E-02, E-03 | ○ |
| C-02 | トップページ-国際化対応（補助機能） | E-03 | ○ |
| C-03 | パッド編集画面-パッド変更同期（主機能） | E-04, E-14 | ○ |
| C-04 | パッド編集画面-ユーザー参加処理（主機能） | E-04, E-14 | ○ |
| C-05 | パッド編集画面-変更セット適用（主機能） | E-04, E-14 | ○ |
| C-06 | パッド編集画面-カーソル位置同期（主機能） | E-04, E-14 | ○ |
| C-07 | パッド編集画面-ユーザー情報更新（主機能） | E-04 | ○ |
| C-08 | パッド編集画面-チャット履歴取得（補助機能） | E-04 | ○ |
| C-09 | パッド編集画面-チャットメッセージ追加（補助機能） | E-04 | ○ |
| C-10 | パッド編集画面-ファイルインポート（補助機能） | E-04, E-15 | ○ |
| C-11 | パッド編集画面-テキストエクスポート（補助機能） | E-04, E-16 | ○ |
| C-12 | パッド編集画面-HTMLエクスポート（補助機能） | E-04, E-16 | ○ |
| C-13 | パッド編集画面-Etherpadエクスポート（補助機能） | E-04, E-16 | ○ |
| C-14 | パッド編集画面-ドキュメント変換エクスポート（補助機能） | E-04, E-16 | ○ |
| C-15 | パッド編集画面-パッド削除（補助機能） | E-04 | ○ |
| C-16 | パッド編集画面-国際化対応（補助機能） | E-04 | ○ |
| C-17 | パッド編集画面-リビジョン数取得（API連携） | **根拠不足** | △ |
| C-18 | パッド編集画面-アクティブユーザー数取得（API連携） | E-04, E-14 | ○ |
| C-19 | パッド編集画面-アクティブユーザー一覧取得（API連携） | E-04 | ○ |
| C-20 | タイムスライダー画面-リビジョン数取得（主機能） | E-05 | ○ |
| C-21 | タイムスライダー画面-リビジョン変更セット取得（主機能） | **根拠不足** | △ |
| C-22 | タイムスライダー画面-パッド著者一覧取得（主機能） | E-05 | ○ |
| C-23 | タイムスライダー画面-テキストエクスポート（補助機能） | E-05, E-16 | ○ |
| C-24 | タイムスライダー画面-HTMLエクスポート（補助機能） | E-05, E-16 | ○ |
| C-25 | タイムスライダー画面-Etherpadエクスポート（補助機能） | E-05, E-16 | ○ |
| C-26 | タイムスライダー画面-ドキュメント変換エクスポート（補助機能） | E-05, E-16 | ○ |
| C-27 | タイムスライダー画面-国際化対応（補助機能） | E-05 | ○ |
| C-28 | SSOログイン画面-ログイン認証（主機能） | E-06, E-02 | ○ |
| C-29 | SSOログイン画面-OAuth2認証（主機能） | E-06, E-02 | ○ |
| C-30 | 同意画面-同意処理（主機能） | E-07, E-02 | ○ |
| C-31 | 同意画面-OAuth2認証（主機能） | E-07, E-02 | ○ |
| C-32 | 管理者ログイン画面-ログイン認証（主機能） | E-08 | ○ |
| C-33 | プラグイン管理画面-プラグイン管理（主機能） | E-09, E-02 | ○ |
| C-34 | プラグイン管理画面-統計情報取得（API連携） | E-09 | ○ |
| C-35 | 設定管理画面-設定管理（主機能） | E-10, E-02 | ○ |
| C-36 | 設定管理画面-設定ファイル読み込み（主機能） | E-10, E-02 | ○ |
| C-37 | ヘルプ/情報画面-統計情報取得（主機能） | E-11 | ○ |
| C-38 | ヘルプ/情報画面-プラグイン管理（補助機能） | E-11 | ○ |
| C-39 | パッド管理画面-パッド管理（主機能） | E-12, E-02 | ○ |
| C-40 | パッド管理画面-全パッド一覧取得（主機能） | E-12 | ○ |
| C-41 | パッド管理画面-パッド作成（補助機能） | E-12 | ○ |
| C-42 | パッド管理画面-パッド削除（補助機能） | E-12 | ○ |
| C-43 | パッド管理画面-最終編集日時取得（主機能） | E-12 | ○ |
| C-44 | パッド管理画面-アクティブユーザー数取得（主機能） | E-12 | ○ |
| C-45 | パッド管理画面-リビジョン数取得（主機能） | E-12 | ○ |
| C-46 | コミュニケーション画面-クライアントメッセージ送信（主機能） | E-13, E-02 | ○ |
| C-47 | コミュニケーション画面-統計情報取得（補助機能） | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-17（パッド編集画面-リビジョン数取得）**: パッド編集画面でリビジョン数を直接取得・表示するコードパスが明示的に確認できなかった。Socket.IO経由で初期データとして送信される可能性があるが、詳細な確認が必要。
  - 候補：`src/node/handler/PadMessageHandler.ts` / `src/static/js/pad.ts` / Socket.IOイベントハンドラー
- **C-21（タイムスライダー画面-リビジョン変更セット取得）**: タイムスライダーの再生時にリビジョン変更セットを取得するSocket.IOメッセージ名の詳細確認が必要。
  - 候補：`src/static/js/timeslider.ts` / `src/static/js/broadcast_slider.ts` / Socket.IOイベントハンドラー

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体的にソースコードとの対応が明確で、信頼度0.96と高い
- **1: 中リスク** - API連携種別のマッピングについては、実際のSocket.IOメッセージ名との照合が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧.csvのNo列と画面Noの対応が正しいか確認
- [ ] 機能一覧.csvのNo列と機能Noの対応が正しいか確認
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か確認
- [ ] パッド編集画面のSocket.IO経由のAPI連携が網羅されているか確認
- [ ] タイムスライダー画面のリビジョン取得ロジックを実際のコードで確認
