# 画面設計書 1-トップページ（パッド作成）

## 概要

本ドキュメントは、Etherpad Liteのトップページ（パッド作成）画面の設計内容を記述するものである。この画面は、ユーザーがEtherpadにアクセスした際に最初に表示される画面であり、新規パッドの作成や既存パッドへのアクセスを行うためのエントリーポイントとなる。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、Etherpadのメイン機能である「リアルタイム共同編集」を開始するためのゲートウェイとして機能する。ユーザーは新規にパッドを作成するか、既存のパッド名を入力してアクセスすることで、共同編集作業を開始できる。チームメンバーとの迅速なドキュメント共有やブレインストーミング、会議メモの共同作成など、様々なコラボレーションシナリオに対応している。

**画面へのアクセス方法**：ブラウザでEtherpadサーバーのルートURL（/）にアクセスすることで本画面が表示される。ブックマークや直接URLの入力、他のシステムからのリンク経由でアクセス可能である。

**主要な操作・処理内容**：
1. 「新規パッド作成」ボタンをクリックすると、ランダムな名前を持つ新規パッドが自動生成され、パッド編集画面へ遷移する
2. パッド名入力フォームに任意のパッド名を入力し、「作成/開く」ボタンを押すと、そのパッド名でパッド編集画面へ遷移する（存在しない場合は新規作成される）
3. 最近使用したパッド一覧から既存のパッドを選択してアクセスする（showRecentPads設定が有効な場合）
4. セッション転送機能により、別デバイスへセッションを引き継ぐ

**画面遷移**：
- 遷移元: 外部リンク、ブックマーク、直接URL入力
- 遷移先: パッド編集画面（/p/:pad）

**権限による表示制御**：settings.requireSessionがtrueの場合、パッド作成フォームは表示されず、セッションが必要となる。settings.editOnlyがtrueの場合、「新規パッド作成」ボタンの代わりに「パッドを開く」ボタンが表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | パッド作成 | 主機能 | 新規パッド名を入力してパッドを作成する |
| 75 | 国際化対応 | 補助機能 | 画面表示の多言語対応処理 |

## 画面種別

登録 / ナビゲーション

## URL/ルーティング

- **URL**: `/`
- **HTTPメソッド**: GET
- **ルーティング定義**: `src/node/hooks/express/specialpages.ts` の `expressCreateServer` フック内で定義

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|---------|------|--------|------|
| パッド名 | padname | 入力 | テキスト | - | 50文字 | 作成または開くパッドの名前 |
| セッション転送コード | codeInput | 入力 | テキスト | - | - | 他デバイスからセッションを受け取る際のコード |

## 表示項目

| 項目名 | 項目ID | 説明 |
|--------|--------|------|
| ページタイトル | title | settings.titleの値が表示される |
| 新規パッド作成ボタン | button | 「New Pad」ボタン（settings.editOnly=falseの場合） |
| パッドを開くボタン | button | 「Open Pad」ボタン（settings.editOnly=trueの場合） |
| パッド名入力フォーム | go2Name | パッド名を入力するフォーム |
| 作成/開くボタン | - | 入力されたパッド名でパッドを開く |
| 最近のパッド一覧 | recent-pads | 最近使用したパッドの一覧（showRecentPads設定時） |
| 設定ダイアログ | settings-dialog | セッション転送設定のダイアログ |

## イベント仕様

### 1-新規パッド作成ボタン押下

ユーザーが「New Pad」ボタンをクリックすると、クライアント側のJavaScriptが実行され、ランダムなパッド名が生成される。その後、`/p/{ランダムなパッド名}` へリダイレクトされ、パッド編集画面へ遷移する。

### 2-パッド名入力後の作成/開くボタン押下

ユーザーがパッド名入力フォームに名前を入力し、「OK」ボタンまたはEnterキーを押下すると、`/p/{入力されたパッド名}` へリダイレクトされる。パッドが存在しない場合は新規に作成され、存在する場合は既存パッドが開かれる。

### 3-セッション転送ボタン押下

設定ダイアログ内の「Transfer now」ボタンを押下すると、現在のセッション情報がコード化され、別デバイスへの転送準備が行われる。転送コードを受け取る側は「Receive session」タブでコードを入力して認証する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| パッド名入力後の遷移 | pad:{padId} | INSERT (遷移先で実行) | 新規パッドの場合、パッド編集画面でパッドレコードが作成される |

### テーブル別更新項目詳細

#### pad:{padId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | atext | 初期テキスト構造 | パッド作成時に初期化 |
| INSERT | pool | 空の属性プール | パッド作成時に初期化 |
| INSERT | head | 0 | 初期リビジョン番号 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| index.generateNewPad | ボタンラベル | New Pad | 新規パッド作成ボタン |
| index.openPad | ボタンラベル | Open Pad | パッドを開くボタン（editOnlyモード） |
| index.labelPad | ラベル | or create/open a Pad with the name | パッド名入力フォームのラベル |
| index.createOpenPad | ボタンラベル | OK | パッド名入力後の送信ボタン |
| index.transferSessionTitle | タブタイトル | Transfer session | セッション転送タブ |
| index.receiveSessionTitle | タブタイトル | Receive session | セッション受信タブ |

## 例外処理

| 例外状態 | 対応処理 | 表示内容 |
|---------|---------|---------|
| JavaScript無効 | フォーム送信不可 | フォームが機能しない |
| requireSession設定時 | パッド作成UIを非表示 | パッド名入力フォームが表示されない |
| 無効なパッド名入力 | クライアント側バリデーション | 最大50文字制限 |

## 備考

- パッド名には特殊文字を含めることが可能だが、URLエンコーディングに注意が必要
- settings.skinNameで指定されたスキンに応じてindex.cssとindex.jsがロードされる
- PWA対応のためmanifest.jsonへのリンクが含まれる
- 多言語対応はlocales.jsonから読み込まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

パッド作成時にはクライアントからサーバーへ遷移が発生するため、この画面単体でのデータ構造は比較的シンプルである。主にフォーム入力値と設定値の関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Settings.ts | `src/node/utils/Settings.ts` | settings.title, settings.requireSession, settings.editOnly, settings.showRecentPads の設定項目を理解する |

**読解のコツ**: EJSテンプレートで使用される `<%=settings.xxx%>` の形式で設定値が参照されている点に注目する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | specialpages.ts | `src/node/hooks/express/specialpages.ts` | expressCreateServer フック内の `args.app.get('/')` ハンドラーを確認。ルートURLへのリクエスト処理の起点。 |

**主要処理フロー**:
1. **333行目**: 本番環境での `/` ルートハンドラー定義
2. **334行目**: eejs.require でテンプレートをレンダリング
3. **166-168行目**: 開発環境でのハンドラー定義（ライブリロード対応）

#### Step 3: テンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.html | `src/templates/index.html` | 画面の構造とEJSによる条件分岐を理解する |

**主要処理フロー**:
- **215-226行目**: requireSession設定による表示制御
- **216-220行目**: editOnly設定による「New Pad」と「Open Pad」の切り替え
- **219行目**: 新規パッド作成ボタン
- **221-225行目**: パッド名入力フォーム
- **231-237行目**: 最近のパッド一覧表示（showRecentPads設定時）
- **169-204行目**: セッション転送ダイアログ

#### Step 4: クライアントサイドJavaScriptを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | indexBootstrap.js | `src/templates/indexBootstrap.js` | クライアント側のエントリーポイント。パッド作成ボタンのイベントハンドリング |

### プログラム呼び出し階層図

```
[ブラウザ] GET /
    │
    ├─ express.Router (specialpages.ts)
    │      │
    │      └─ eejs.require('templates/index.html')
    │              │
    │              └─ settings オブジェクト参照
    │                     - title
    │                     - requireSession
    │                     - editOnly
    │                     - showRecentPads
    │                     - skinName
    │
    └─ [クライアント] indexBootstrap.js
           │
           ├─ #button クリック → ランダムパッド名生成 → /p/:pad へ遷移
           │
           └─ #go2Name 送信 → /p/:padname へ遷移
```

### データフロー図

```
[入力]                    [処理]                         [出力]

パッド名入力 ───────▶ フォーム送信 ───────────────▶ /p/:pad へリダイレクト
(#padname)              (JavaScript)

新規パッド作成 ─────▶ ランダムID生成 ─────────────▶ /p/:randomId へリダイレクト
ボタン押下              (JavaScript)

設定値 ────────────▶ テンプレートレンダリング ──▶ HTML出力
(settings.*)            (EJS)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.html | `src/templates/index.html` | テンプレート | 画面のHTMLテンプレート |
| specialpages.ts | `src/node/hooks/express/specialpages.ts` | ソース | ルーティング・レンダリング処理 |
| indexBootstrap.js | `src/templates/indexBootstrap.js` | テンプレート | クライアントサイドJSのエントリーポイント |
| Settings.ts | `src/node/utils/Settings.ts` | ソース | 設定値の管理 |
| index.css | `src/static/skins/{skinName}/index.css` | スタイル | スキン別のCSS |
| index.js | `src/static/skins/{skinName}/index.js` | ソース | スキン別のJS |
| locales.json | `src/locales/*.json` | 設定 | 多言語対応の翻訳ファイル |
