# 画面設計書 4-SSOログイン画面

## 概要

本ドキュメントは、Etherpad LiteのSSOログイン画面の設計内容を記述するものである。この画面は、OAuth2/OpenID Connect（OIDC）認証フローにおけるユーザー認証のためのログインフォーム画面である。ユーザー名とパスワードを入力して認証を行う。

### 本画面の処理概要

**業務上の目的・背景**：Etherpadを外部の認証プロバイダーと連携させる場合、OAuth2/OIDC認証フローが使用される。本画面はそのフローにおける認証ステップを担い、ユーザーが正当なユーザーであることを確認する。これにより、組織の既存の認証基盤（LDAP、Active Directory、各種IdP）と統合し、シングルサインオン（SSO）を実現できる。

**画面へのアクセス方法**：認証が必要なパッドにアクセスした際、または明示的にログインが求められた際にリダイレクトされる。URLパスは `/interaction/:uid` 形式で、`:uid` は認証フローのセッション識別子である。

**主要な操作・処理内容**：
1. ユーザー名（Username）の入力
2. パスワード（Password）の入力
3. パスワードの表示/非表示切り替え（目のアイコン）
4. ログインボタン押下による認証リクエスト送信
5. 認証成功時は同意画面または元のリソースへリダイレクト
6. 認証失敗時はエラーメッセージ表示

**画面遷移**：
- 遷移元: 認証が必要なパッドへのアクセス、認証フロー開始
- 遷移先: 同意画面（/interaction/:uid）、パッド編集画面（認証成功後）

**権限による表示制御**：本画面自体は認証前に表示されるため、権限による表示制御は行われない。既に認証済みの場合は本画面をスキップして同意画面または元のリソースへ直接リダイレクトされる場合がある。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | ログイン認証 | 主機能 | ユーザー名とパスワードを入力して認証処理 |
| 48 | OAuth2認証 | 主機能 | OpenID Connect準拠のOAuth2認証フローを処理 |

## 画面種別

認証 / ログイン

## URL/ルーティング

- **URL**: `/interaction/:uid`
- **HTTPメソッド**: GET（画面表示）、POST（認証リクエスト）
- **パラメータ**: `:uid` - 認証フローのセッション識別子
- **テンプレート**: `ui/login.html`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|---------|------|--------|------|
| ユーザー名 | login | 入力 | テキスト | 必須 | - | 認証用ユーザー名 |
| パスワード | password | 入力 | パスワード | 必須 | - | 認証用パスワード |

## 表示項目

| 項目名 | 項目ID | 説明 |
|--------|--------|------|
| ページタイトル | - | 「SSO Etherpad」固定 |
| ロゴ/タイトル | login-title | 「Etherpad」とクライアント名 |
| ユーザー名入力欄 | login | プレースホルダー「Username」 |
| パスワード入力欄 | password | プレースホルダー「Password」 |
| パスワード表示アイコン | eye-visible | パスワードを表示状態にする |
| パスワード非表示アイコン | eye-hide | パスワードを非表示状態にする |
| ログインボタン | - | 「Login」ボタン |
| エラー表示領域 | error | 認証エラーメッセージ |
| クライアント名表示 | client | 認証を要求しているクライアント名 |

## イベント仕様

### 1-ログインボタン押下

ユーザー名とパスワードを入力し、ログインボタンを押下すると、フォームがPOSTで送信される。サーバー側でOIDCプロバイダーに対して認証が行われる。認証成功時は同意画面または認証コールバックURLへリダイレクトされる。認証失敗時はエラーメッセージが`#error`要素に表示される。

### 2-パスワード表示切り替え

パスワード入力欄の右側にある目のアイコン（eye-visible/eye-hide）をクリックすると、パスワードの表示/非表示が切り替わる。表示状態では入力内容が平文で表示され、非表示状態ではマスクされる。

### 3-フォームバリデーション

ユーザー名とパスワードの両フィールドには`required`属性が設定されており、HTML5のネイティブバリデーションにより空欄での送信は防止される。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はOAuth2/OIDC認証フローの一部であり、直接Etherpadのデータベースを更新しない。認証情報は外部のIdPまたはOIDCプロバイダーで管理される。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ログイン成功 | oidc:interaction:{uid} | UPDATE | 認証状態の更新（OIDC側） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | タイトル | SSO Etherpad | ページタイトル |
| - | ラベル | Etherpad | ログインフォームタイトル |
| - | プレースホルダー | Username | ユーザー名入力欄 |
| - | プレースホルダー | Password | パスワード入力欄 |
| - | ボタン | Login | ログインボタン |
| - | エラー | (動的) | 認証失敗時 |

## 例外処理

| 例外状態 | 対応処理 | 表示内容 |
|---------|---------|---------|
| ユーザー名未入力 | フォーム送信阻止 | ブラウザのネイティブバリデーションエラー |
| パスワード未入力 | フォーム送信阻止 | ブラウザのネイティブバリデーションエラー |
| 認証失敗 | エラー表示 | `#error`要素にエラーメッセージ |
| セッションタイムアウト | 認証フロー再開始 | ログイン画面に戻る |
| 無効なuid | エラーページ | 認証フロー無効のエラー |

## 備考

- 本画面はViteベースのフロントエンド（`/src/main.ts`）で動的に構築される
- CSSは`ui/`ディレクトリ内のスタイルファイルが適用される
- パスワード表示切り替えはSVGアイコンで実装（Heroicons使用）
- OAuth2/OIDCの設定はsettings.jsonの`sso`セクションで行う
- 本画面は認証が有効化されている場合のみ使用される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OAuth2/OIDC認証フローでは、認証状態がセッション（interaction）として管理される。`uid`パラメータがセッション識別子として機能する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Settings.ts | `src/node/utils/Settings.ts` | sso設定項目の構造を理解 |

**読解のコツ**: OIDCプロバイダーの設定（issuer, client_id, client_secret等）がsettings.jsonで定義される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | login.html | `ui/login.html` | 画面の静的HTML構造 |
| 2-2 | main.ts | `ui/src/main.ts` | クライアント側エントリーポイント |

**主要処理フロー**:
1. **16-17行目**: ユーザー名入力欄（required属性付き）
2. **19-28行目**: パスワード入力欄と表示切り替えアイコン
3. **30行目**: ログインボタン
4. **31行目**: エラー表示領域
5. **36行目**: main.tsでの動的処理読み込み

#### Step 3: サーバーサイドの認証処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | oidc.ts | `src/node/hooks/express/oidc.ts` | OIDC認証フローのエンドポイント |

### プログラム呼び出し階層図

```
[ブラウザ] GET /interaction/:uid
    │
    ├─ express.Router (oidc.ts)
    │      │
    │      └─ login.html 配信
    │              │
    │              └─ main.ts 実行
    │
    └─ [ユーザー操作] ログインボタン押下
           │
           ├─ フォームPOST送信
           │      │
           │      └─ [サーバー] OIDC認証処理
           │              │
           │              ├─ 認証成功
           │              │      │
           │              │      └─ 同意画面 or コールバックへリダイレクト
           │              │
           │              └─ 認証失敗
           │                     │
           │                     └─ エラーメッセージ表示
           │
           └─ [クライアント] パスワード表示切り替え
                  │
                  └─ input type="password" ⇔ type="text" 切り替え
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー名入力 ──────▶ フォームPOST ────────────▶ OIDC認証
パスワード入力                                        │
                                                       ▼
                                               [サーバー]
                                                       │
                                               認証検証
                                                       │
                              ┌───────────────────┴───────────────────┐
                              ▼                                       ▼
                        認証成功                                認証失敗
                              │                                       │
                              ▼                                       ▼
                        同意画面へ                              エラー表示
                        リダイレクト                            (#error)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| login.html | `ui/login.html` | テンプレート | 画面のHTMLテンプレート |
| main.ts | `ui/src/main.ts` | ソース | クライアント側エントリーポイント |
| oidc.ts | `src/node/hooks/express/oidc.ts` | ソース | OIDC認証処理 |
| Settings.ts | `src/node/utils/Settings.ts` | ソース | SSO設定管理 |
| vite.config.ts | `ui/vite.config.ts` | 設定 | Viteビルド設定 |
