# 画面設計書 5-同意画面

## 概要

本ドキュメントは、Etherpad Liteの同意画面（Consent Screen）の設計内容を記述するものである。この画面は、OAuth2/OpenID Connect認証フローにおけるユーザー同意確認画面であり、認証後にアプリケーションへのアクセス許可を求める。

### 本画面の処理概要

**業務上の目的・背景**：OAuth2/OIDC認証フローでは、ユーザーが認証に成功した後、アプリケーション（リライングパーティ）が要求するスコープ（アクセス権限）への同意を求めることがある。本画面はその同意取得のステップを担う。これにより、ユーザーは自分の情報やリソースへのアクセスを明示的に許可または拒否できる。

**画面へのアクセス方法**：SSOログイン画面での認証成功後、同意が必要な場合に自動的にリダイレクトされる。URLパスはログイン画面と同じ `/interaction/:uid` 形式だが、認証状態に応じて表示内容が切り替わる。

**主要な操作・処理内容**：
1. 同意ボタン押下によるアクセス許可
2. 同意後は認証コールバックURLへリダイレクト
3. 最終的に元のリソース（パッド編集画面等）へ遷移

**画面遷移**：
- 遷移元: SSOログイン画面（認証成功後）
- 遷移先: パッド編集画面（同意後の認証コールバック経由）

**権限による表示制御**：本画面は認証済みユーザーに対してのみ表示される。未認証の場合はSSOログイン画面へリダイレクトされる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | 同意処理 | 主機能 | OAuth2フローにおけるユーザー同意を処理 |
| 48 | OAuth2認証 | 主機能 | OAuth2認証フローの一部として同意を取得 |

## 画面種別

認証 / 同意確認

## URL/ルーティング

- **URL**: `/interaction/:uid`（認証後の同意フェーズ）
- **HTTPメソッド**: GET（画面表示）、POST（同意送信）
- **パラメータ**: `:uid` - 認証フローのセッション識別子
- **テンプレート**: `ui/consent.html`

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 最大長 | 説明 |
|--------|--------|----------|---------|------|--------|------|
| 同意フラグ | prompt | 入力（hidden） | テキスト | 必須 | - | 値は固定で「consent」 |

## 表示項目

| 項目名 | 項目ID | 説明 |
|--------|--------|------|
| ページタイトル | - | 「Consent Etherpad」固定 |
| ロゴ/タイトル | login-title | 「Etherpad」とクライアント名 |
| 同意ボタン | - | 「Login」ボタン（同意を意味する） |
| エラー表示領域 | error | エラーメッセージ表示 |
| クライアント名表示 | client | 同意を要求しているクライアント名 |

## イベント仕様

### 1-同意ボタン押下

同意ボタン（「Login」と表示）を押下すると、フォームがPOSTで送信される。隠しフィールドとして`prompt=consent`が含まれ、サーバー側でユーザーが同意したことが記録される。その後、OAuth2認証フローが完了し、認証コードと共に元のアプリケーションへリダイレクトされる。

## データベース更新仕様

### 操作別データベース影響一覧

本画面はOAuth2/OIDC認証フローの一部であり、直接Etherpadのデータベースを更新しない。同意情報は外部のOIDCプロバイダーで管理される。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 同意送信 | oidc:grant:{grantId} | INSERT/UPDATE | 同意情報の記録（OIDC側） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | タイトル | Consent Etherpad | ページタイトル |
| - | ラベル | Etherpad | フォームタイトル |
| - | ボタン | Login | 同意ボタン |
| - | エラー | (動的) | 同意処理失敗時 |

## 例外処理

| 例外状態 | 対応処理 | 表示内容 |
|---------|---------|---------|
| セッションタイムアウト | 認証フロー再開始 | ログイン画面に戻る |
| 無効なuid | エラーページ | 認証フロー無効のエラー |
| 同意処理失敗 | エラー表示 | `#error`要素にエラーメッセージ |
| 認証状態無効 | ログイン画面へ | SSOログイン画面へリダイレクト |

## 備考

- 本画面はViteベースのフロントエンド（`/src/consent.ts`）で動的に構築される
- ログイン画面とは異なるTypeScriptファイル（consent.ts）を使用
- 同意ボタンのラベルが「Login」となっているが、実際の動作は同意送信
- 通常のOAuth2フローでは、同意画面でスコープの一覧が表示されるが、本実装ではシンプルな同意ボタンのみ
- クライアント名（`#client`）により、どのアプリケーションへの同意かを識別可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OAuth2同意フローでは、認証成功後のインタラクションセッション内で同意状態が管理される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Settings.ts | `src/node/utils/Settings.ts` | sso設定項目の構造を理解 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | consent.html | `ui/consent.html` | 画面の静的HTML構造 |
| 2-2 | consent.ts | `ui/src/consent.ts` | クライアント側エントリーポイント |

**主要処理フロー**:
1. **14行目**: フォーム定義（method="post"）
2. **15行目**: 隠しフィールド（prompt=consent）
3. **16行目**: 同意ボタン
4. **17行目**: エラー表示領域
5. **22行目**: consent.tsでの動的処理読み込み

### プログラム呼び出し階層図

```
[ブラウザ] GET /interaction/:uid（認証済み）
    │
    ├─ express.Router (oidc.ts)
    │      │
    │      └─ consent.html 配信
    │              │
    │              └─ consent.ts 実行
    │
    └─ [ユーザー操作] 同意ボタン押下
           │
           ├─ フォームPOST送信
           │      │
           │      └─ [サーバー] OIDC同意処理
           │              │
           │              ├─ 同意記録
           │              │
           │              └─ 認証コード発行
           │                     │
           │                     └─ コールバックURLへリダイレクト
           │                            │
           │                            └─ パッド編集画面へ
```

### データフロー図

```
[入力]                    [処理]                         [出力]

同意ボタン押下 ──────▶ フォームPOST ────────────▶ OIDC同意処理
(prompt=consent)                                      │
                                                       ▼
                                               [サーバー]
                                                       │
                                               同意記録
                                                       │
                                                       ▼
                                               認証コード発行
                                                       │
                                                       ▼
                                               コールバックURL
                                               リダイレクト
                                                       │
                                                       ▼
                                               パッド編集画面
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| consent.html | `ui/consent.html` | テンプレート | 画面のHTMLテンプレート |
| consent.ts | `ui/src/consent.ts` | ソース | クライアント側エントリーポイント |
| oidc.ts | `src/node/hooks/express/oidc.ts` | ソース | OIDC同意処理 |
| Settings.ts | `src/node/utils/Settings.ts` | ソース | SSO設定管理 |
