# 画面設計書 9-ヘルプ/情報画面

## 概要

本ドキュメントは、Etherpad Liteのヘルプ/情報画面の設計内容を記述するものである。この画面は、Etherpadのバージョン情報、インストール済みプラグイン、パーツ、フックの一覧を表示する情報画面である。

### 本画面の処理概要

**業務上の目的・背景**：システム管理者やサポート担当者がEtherpadの稼働状況を把握するための情報を提供する。バージョン情報はトラブルシューティングや互換性確認に、プラグイン/パーツ/フック一覧は拡張機能の把握とデバッグに活用される。最新バージョンとの比較により、更新の必要性も確認できる。

**画面へのアクセス方法**：管理画面のサイドメニューから「Help」を選択してアクセス。URLパスは `/admin/help`。

**主要な操作・処理内容**：
1. Etherpadバージョン情報の表示（現在バージョン、最新バージョン、Gitコミット）
2. インストール済みプラグイン一覧の表示
3. インストール済みパーツ一覧の表示
4. サーバーフック一覧の表示（プラグイン別）
5. クライアントフック一覧の表示（プラグイン別）

**画面遷移**：
- 遷移元: サイドメニュー
- 遷移先: サイドメニュー経由で他の管理画面

**権限による表示制御**：管理者権限（is_admin: true）を持つユーザーのみアクセス可能。WebSocket接続時にセッションの権限が検証される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 64 | 統計情報取得 | 主機能 | Etherpadのバージョン情報を取得して表示 |
| 61 | プラグイン管理 | 補助機能 | インストール済みプラグイン一覧を取得して表示 |

## 画面種別

情報表示 / ヘルプ

## URL/ルーティング

- **URL**: `/admin/help`
- **HTTPメソッド**: GET（画面表示）
- **WebSocket名前空間**: `/settings`
- **コンポーネント**: `admin/src/pages/HelpPage.tsx`

## 入出力項目

本画面は情報表示専用のため、ユーザー入力項目はない。

## 表示項目

| 項目名 | 項目ID | 説明 |
|--------|--------|------|
| バージョンセクション | - | 「Version」（i18n: admin_plugins_info.version） |
| 現在バージョン | epVersion | Etherpadの現在バージョン番号 |
| 最新バージョン | latestVersion | npmで公開されている最新バージョン |
| Gitコミット | gitCommit | 現在のGitコミットSHA |
| インストール済みプラグインセクション | - | 「Installed Plugins」（i18n: admin_plugins.installed） |
| プラグインリスト | installedPlugins | プラグイン名の一覧 |
| パーツセクション | - | 「Parts」（i18n: admin_plugins_info.parts） |
| パーツリスト | installedParts | パーツ名の一覧 |
| サーバーフックセクション | - | 「Hooks」（i18n: admin_plugins_info.hooks） |
| サーバーフックリスト | installedServerHooks | フック名とプラグインのマッピング |
| クライアントフックセクション | - | 「Client Hooks」（i18n: admin_plugins_info.hooks_client） |
| クライアントフックリスト | installedClientHooks | クライアントフック名とプラグインのマッピング |

## イベント仕様

### 1-ヘルプ情報取得

画面アクセス時、WebSocket経由でヘルプ情報リクエストが送信される（`help`イベント）。サーバーは以下の情報を収集して返送する（`reply:help`イベント）：
- Etherpadバージョン（getEpVersion）
- Gitコミット（getGitCommit）
- インストール済みプラグイン一覧
- インストール済みパーツ一覧
- サーバーフック一覧
- クライアントフック一覧
- 最新バージョン（UpdateCheckから取得）

### 2-フック表示

フック一覧は階層構造で表示される。各フック名の下にそのフックを実装しているプラグイン、さらにその下に具体的な関数名が表示される。

## データベース更新仕様

### 操作別データベース影響一覧

本画面は情報表示専用であり、データベースへの更新は発生しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| - | - | - | データベース更新なし |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| admin_plugins_info.version | セクション | Version | バージョンセクション |
| admin_plugins_info.version_number | ラベル | Current Version | 現在バージョンラベル |
| admin_plugins_info.version_latest | ラベル | Latest Version | 最新バージョンラベル |
| admin_plugins.installed | セクション | Installed Plugins | プラグインセクション |
| admin_plugins_info.parts | セクション | Parts | パーツセクション |
| admin_plugins_info.hooks | セクション | Hooks | サーバーフックセクション |
| admin_plugins_info.hooks_client | セクション | Client Hooks | クライアントフックセクション |

## 例外処理

| 例外状態 | 対応処理 | 表示内容 |
|---------|---------|---------|
| ヘルプ情報取得前 | 空表示 | 空のdiv要素 |
| WebSocket切断 | 自動再接続 | 接続復帰時に再取得 |
| 権限不足 | 接続拒否 | WebSocket接続が確立されない |

## 備考

- helpDataがnullの場合は空のdiv要素を返す（ローディング状態）
- フックは`renderHooks`関数で再帰的にレンダリング
- Map構造をオブジェクトに変換する`mapToObject`関数を使用
- 最新バージョンはUpdateCheck機能から取得（定期的に更新確認）
- GitコミットSHAはビルド時に埋め込まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ヘルプ画面では、サーバーから取得した情報を`HelpObj`型で管理する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Plugin.ts | `admin/src/pages/Plugin.ts` | HelpObj型定義（28-36行目） |
| 1-2 | store.ts | `admin/src/store/store.ts` | settingsSocket の状態管理 |

**読解のコツ**: `HelpObj`にはinstalledServerHooksとinstalledClientHooksがRecord型で定義されており、階層構造を持つ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HelpPage.tsx | `admin/src/pages/HelpPage.tsx` | ヘルプ画面コンポーネント全体 |

**主要処理フロー**:
1. **6行目**: HelpPageコンポーネント定義
2. **7行目**: settingsSocket取得
3. **8行目**: helpDataステート定義
4. **10-17行目**: useEffect - reply:helpイベントリスナー設定とhelpイベント送信
5. **19-31行目**: renderHooks関数 - フックの階層表示
6. **35行目**: helpDataがない場合の早期リターン
7. **37-68行目**: 情報表示のレンダリング

#### Step 3: サーバーサイドのヘルプ処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | adminsettings.ts | `src/node/hooks/express/adminsettings.ts` | helpイベントハンドラー（75-103行目） |

**主要処理フロー**:
- **75行目**: helpイベントハンドラー
- **76行目**: getGitCommit()呼び出し
- **77行目**: getEpVersion()呼び出し
- **79-80行目**: プラグインのフック情報取得
- **82-92行目**: Mapをオブジェクトに変換
- **94-102行目**: reply:helpイベントで情報返送

### プログラム呼び出し階層図

```
[ブラウザ] GET /admin/help
    │
    ├─ React SPA (HelpPage.tsx)
    │      │
    │      ├─ WebSocket接続 (/settings)
    │      │      │
    │      │      └─ [サーバー] adminsettings.ts
    │      │              │
    │      │              └─ help イベント
    │      │                     │
    │      │                     ├─ getGitCommit()
    │      │                     ├─ getEpVersion()
    │      │                     ├─ plugins.getPlugins()
    │      │                     ├─ plugins.getParts()
    │      │                     ├─ plugins.getHooks('hooks')
    │      │                     ├─ plugins.getHooks('client_hooks')
    │      │                     └─ getLatestVersion()
    │      │
    │      └─ UIレンダリング
    │             ├─ バージョン情報
    │             ├─ プラグイン一覧
    │             ├─ パーツ一覧
    │             └─ フック一覧
```

### データフロー図

```
[入力]                    [処理]                         [出力]

画面アクセス ──────▶ WebSocket 'help' ─────────▶ 情報収集
                                                       │
                                                       ▼
                                               [サーバー]
                                               - getEpVersion
                                               - getGitCommit
                                               - getPlugins
                                               - getParts
                                               - getHooks
                                               - getLatestVersion
                                                       │
                                                       ▼
                                               'reply:help' ────────▶ setHelpData
                                                                           │
                                                                           ▼
                                                                    UIレンダリング
                                                                    - バージョン表示
                                                                    - リスト表示
                                                                    - フック階層表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HelpPage.tsx | `admin/src/pages/HelpPage.tsx` | ソース | ヘルプ画面コンポーネント |
| Plugin.ts | `admin/src/pages/Plugin.ts` | ソース | HelpObj型定義 |
| store.ts | `admin/src/store/store.ts` | ソース | 状態管理ストア |
| adminsettings.ts | `src/node/hooks/express/adminsettings.ts` | ソース | WebSocketハンドラー |
| Settings.ts | `src/node/utils/Settings.ts` | ソース | getEpVersion, getGitCommit |
| UpdateCheck.ts | `src/node/utils/UpdateCheck.ts` | ソース | getLatestVersion |
| plugins.ts | `src/static/js/pluginfw/plugins.ts` | ソース | getPlugins, getParts, getHooks |
