---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-トップページ（パッド作成）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **最近のパッド一覧の実装詳細**：クライアント側の実装詳細が不明確
  2. **セッション転送機能の詳細動作**：クライアント側JavaScriptの実装詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/templates/index.html` - 画面テンプレート
- E-02: `src/node/hooks/express/specialpages.ts` - ルーティング定義（333-334行目）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/` である | E-02, E-03 | ○ |
| C-02 | テンプレートは `src/templates/index.html` を使用 | E-01, E-02 | ○ |
| C-03 | パッド名の最大長は50文字 | E-01 (223行目 maxlength="50") | ○ |
| C-04 | settings.requireSessionでパッド作成UIを非表示 | E-01 (215行目 条件分岐) | ○ |
| C-05 | settings.editOnlyでボタンテキストが変更される | E-01 (216-220行目 条件分岐) | ○ |
| C-06 | settings.showRecentPadsで最近のパッド一覧表示 | E-01 (231-237行目 条件分岐) | ○ |
| C-07 | 新規パッド作成ボタンのIDは `button` | E-01 (219行目) | ○ |
| C-08 | パッド名入力フォームのIDは `go2Name` | E-01 (221行目) | ○ |
| C-09 | セッション転送ダイアログが存在する | E-01 (169-204行目) | ○ |
| C-10 | 関連機能No.6「パッド作成」が主機能 | E-04 | ○ |
| C-11 | 関連機能No.75「国際化対応」が補助機能 | E-04 | ○ |
| C-12 | パッド編集画面への遷移パス | E-05 | ○ |
| C-13 | settings.titleがページタイトルに使用される | E-01 (4行目) | ○ |
| C-14 | スキンに応じたCSSがロードされる | E-01 (150行目) | ○ |
| C-15 | スキンに応じたJSがロードされる | E-01 (242行目) | ○ |
| C-16 | locales.jsonで多言語対応 | E-01 (10行目) | ○ |
| C-17 | manifest.jsonへのリンクがある | E-01 (6行目) | ○ |
| C-18 | 入力フォームにautofocus属性がある | E-01 (223行目) | ○ |
| C-19 | 新規パッド作成時にランダム名が生成される | E-02 (クライアントJS) | ○ |
| C-20 | パッド作成は遷移先で実行される | E-02 | ○ |
| C-21 | expressCreateServerフックでルーティング定義 | E-02 (265行目) | ○ |
| C-22 | 開発環境ではライブリロード対応 | E-02 (371-372行目) | ○ |
| C-23 | 本番環境では静的ビルドを配信 | E-02 (308-335行目) | ○ |
| C-24 | 最近のパッド一覧の詳細実装 | **根拠なし** | △ |
| C-25 | セッション転送コードの生成・検証ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 最近のパッド一覧（recent-pads）の詳細実装がクライアントサイドJavaScript内にあるが、具体的なファイル参照が不足
  - 候補：`src/static/js/` 配下 / indexBootstrap.js / スキン固有JS
- セッション転送機能の詳細なJavaScript実装が未確認
  - 候補：`src/templates/indexBootstrap.js` / スキン固有JS

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なHTML構造と設定値参照
- 0: 低リスク - ルーティング定義
- 1: 中リスク - クライアントサイドJavaScriptの動作詳細（一部推測含む）

## 6) レビュアーチェックリスト（最小）
- [ ] index.htmlテンプレートの条件分岐が設計書の記載と一致するか確認
- [ ] specialpages.tsのルーティング定義が正確か確認
- [ ] 最近のパッド一覧機能の実装箇所を特定し、設計書に追記が必要か検討
- [ ] セッション転送機能の詳細実装を確認し、設計書への追記要否を判断
