---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：11-コミュニケーション画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **C-32 メッセージ履歴の永続化なし**：仕様としてDBに保存しないことが正しいか要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `admin/src/pages/ShoutPage.tsx` (1-82行目)
- E-02: `admin/src/components/ShoutType.ts` (1-13行目)
- E-03: `admin/src/store/store.ts` (1-52行目)
- E-04: `admin/src/App.tsx` (1-120行目)
- E-05: `admin/src/main.tsx` (1-42行目)
- E-06: `src/node/hooks/express/adminsettings.ts` (1-320行目)
- E-07: `src/node/hooks/express/adminplugins.ts` (1-146行目)
- E-08: `src/node/stats.ts` (1-10行目)
- E-09: `src/static/js/pad.ts` (266-278行目)
- E-10: `docs/code-to-docs/画面一覧/画面一覧.csv` (12行目)
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (47-48行目)
- E-12: `docs/code-to-docs/画面一覧/画面遷移図.md` (49-56行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名が「コミュニケーション画面」である | E-10 | ○ |
| C-02 | URLパスが /admin/shout である | E-10, E-05 | ○ |
| C-03 | テンプレートファイルが admin/src/pages/ShoutPage.tsx である | E-10, E-01 | ○ |
| C-04 | 接続中の全ユーザーへメッセージを送信する機能がある | E-01 (35-41行目), E-06 (58-72行目) | ○ |
| C-05 | 機能No.37 クライアントメッセージ送信が主機能である | E-11 | ○ |
| C-06 | 機能No.64 統計情報取得が補助機能である | E-11, E-07 (42-45行目) | ○ |
| C-07 | サイドメニューからアクセス可能 | E-04 (107行目) | ○ |
| C-08 | 管理者権限が必要 | E-06 (24-25行目), E-04 (18-27行目) | ○ |
| C-09 | 入力項目にmessage(必須)がある | E-01 (75行目: required属性) | ○ |
| C-10 | 入力項目にsticky(任意)がある | E-01 (10行目, 69-74行目) | ○ |
| C-11 | 出力項目にtotalUsersがある | E-01 (8行目, 46行目) | ○ |
| C-12 | 出力項目にshoutsがある | E-01 (13行目, 49-63行目) | ○ |
| C-13 | ShoutType型がメッセージ構造を定義 | E-02 | ○ |
| C-14 | Zustandストアでsocket接続を管理 | E-03 (17-22行目, 35-40行目) | ○ |
| C-15 | settingsSocketを使用してshoutイベントを送信 | E-01 (36-39行目) | ○ |
| C-16 | pluginsSocketを使用してgetStatsイベントを送信 | E-01 (31行目) | ○ |
| C-17 | サーバー側で/settings名前空間にshoutハンドラがある | E-06 (58-72行目) | ○ |
| C-18 | サーバー側でメッセージを全クライアントにブロードキャスト | E-06 (70-71行目) | ○ |
| C-19 | /pluginfw/installer名前空間でgetStatsを処理 | E-07 (42-45行目) | ○ |
| C-20 | stats.toJSON()で統計情報を取得 | E-07 (44行目), E-08 | ○ |
| C-21 | パッド編集画面でshoutイベントを受信 | E-09 (266行目) | ○ |
| C-22 | $.gritter.add()でポップアップ表示 | E-09 (269-276行目) | ○ |
| C-23 | stickyフラグでポップアップの固定表示を制御 | E-09 (275行目) | ○ |
| C-24 | Radix UI Switchコンポーネントを使用 | E-01 (4行目, 69-74行目) | ○ |
| C-25 | SendHorizontalアイコン（Lucide React）を使用 | E-01 (2行目, 77行目) | ○ |
| C-26 | メッセージ履歴にタイムスタンプを表示 | E-01 (57-58行目) | ○ |
| C-27 | React Routerで/shoutパスをShoutPageにルーティング | E-05 (24行目) | ○ |
| C-28 | 画面遷移：サイドメニューから他の管理画面へ遷移可能 | E-12 | ○ |
| C-29 | ShoutMessage型はmessageとstickyを持つ | E-06 (53-56行目) | ○ |
| C-30 | messageToSendにCOLLABROOMタイプとshoutMessageタイプを設定 | E-06 (59-68行目) | ○ |
| C-31 | フォームsubmitでpreventDefault()を実行 | E-01 (65-68行目) | ○ |
| C-32 | メッセージ履歴はDBに永続化されない | **根拠なし（コードから推測）** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-32: メッセージ履歴の永続化に関する仕様**
  - ソースコードを確認した限り、shoutメッセージをDBに保存する処理は見当たらない
  - しかし、「保存しない」という明示的な仕様ドキュメントは存在しない
  - 候補: 設計仕様書 / 要件定義書 / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - 画面の基本構成・機能については全てソースコードで確認可能
- **1: 中リスク** - メッセージ履歴が永続化されないことが仕様かバグかの確認が必要
- **0: 低リスク** - Socket.IO通信の仕組みはコードから明確に読み取れる

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス /admin/shout でアクセスできることを実際に確認
- [ ] 管理者以外のアクセス時にログイン画面へリダイレクトされることを確認
- [ ] メッセージ送信時に接続中のパッド編集画面にポップアップが表示されることを確認
- [ ] stickyオプション有効時にポップアップが自動で消えないことを確認
- [ ] ユーザー数表示が実際の接続ユーザー数と一致することを確認
- [ ] ページリロード後にメッセージ履歴が消えることが仕様として許容されるか確認
