---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：3-タイムスライダー画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **再生アニメーションの詳細実装**：timeslider.jsの詳細ロジック未確認
  2. **URLハッシュによるリビジョン指定の詳細**：クライアント側実装の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/templates/timeslider.html` - 画面テンプレート
- E-02: `src/node/hooks/express/specialpages.ts` - ルーティング定義（359-370行目）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/p/:pad/timeslider` である | E-02, E-03 | ○ |
| C-02 | テンプレートは `src/templates/timeslider.html` を使用 | E-01, E-02 | ○ |
| C-03 | タイムスライダーラッパーのIDは `timeslider-wrapper` | E-01 (84行目) | ○ |
| C-04 | スライダーのIDは `timeslider-slider` | E-01 (85行目) | ○ |
| C-05 | スライダーハンドルのIDは `ui-slider-handle` | E-01 (86行目) | ○ |
| C-06 | 再生/一時停止ボタンのIDは `playpause_button_icon` | E-01 (92行目) | ○ |
| C-07 | 前へステップボタンのIDは `leftstep` | E-01 (93行目) | ○ |
| C-08 | 次へステップボタンのIDは `rightstep` | E-01 (94行目) | ○ |
| C-09 | ドキュメント表示領域のIDは `innerdocbody` | E-01 (113行目) | ○ |
| C-10 | エクスポートポップアップのIDは `import_export` | E-01 (122行目) | ○ |
| C-11 | 接続状態ポップアップのIDは `connectivity` | E-01 (153行目) | ○ |
| C-12 | 設定ポップアップのIDは `settings` | E-01 (225行目) | ○ |
| C-13 | フォント選択のセレクトIDは `viewfontmenu` | E-01 (229行目) | ○ |
| C-14 | コンテンツ追従設定のIDは `options-followContents` | E-01 (238行目) | ○ |
| C-15 | リビジョンラベルのIDは `revision_label` | E-01 (65行目) | ○ |
| C-16 | リビジョン日時のIDは `revision_date` | E-01 (66行目) | ○ |
| C-17 | 著者リストのIDは `authorsList` | E-01 (70行目) | ○ |
| C-18 | タイマーのIDは `timer` | E-01 (88行目) | ○ |
| C-19 | 関連機能No.22「リビジョン数取得」が主機能 | E-04 | ○ |
| C-20 | 関連機能No.21「リビジョン変更セット取得」が主機能 | E-04 | ○ |
| C-21 | 関連機能No.24「パッド著者一覧取得」が主機能 | E-04 | ○ |
| C-22 | パッド編集画面からの遷移が可能 | E-05 | ○ |
| C-23 | パッド編集画面への遷移が可能 | E-05 | ○ |
| C-24 | エクスポート形式にtxt, html, etherpad, doc, pdf, odtがある | E-01 (125-143行目) | ○ |
| C-25 | スキンバリアント設定が使用される | E-01 (5行目) | ○ |
| C-26 | socket.io.jsが読み込まれる | E-01 (249行目) | ○ |
| C-27 | 再生アニメーションの詳細実装 | **根拠なし** | △ |
| C-28 | URLハッシュによるリビジョン指定の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 再生アニメーションの詳細実装（setIntervalの間隔など）
  - 候補：`src/static/js/timeslider.js`
- URLハッシュによるリビジョン指定のパース処理
  - 候補：`src/static/js/timeslider.js` / クライアント側JS

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - HTML構造とID属性
- 0: 低リスク - ルーティング定義
- 1: 中リスク - スライダー操作とリビジョン表示の連携

## 6) レビュアーチェックリスト（最小）
- [ ] timeslider.htmlテンプレートの各要素IDが設計書と一致するか確認
- [ ] 関連機能マッピングが画面機能マッピング.csvと一致するか確認
- [ ] エクスポート形式の一覧がテンプレートと一致するか確認
- [ ] timeslider.js を調査し、再生アニメーションの詳細を追記するか検討
- [ ] URLハッシュ処理の実装を確認
