---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：4-SSOログイン画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **OIDC認証フローの詳細処理**：oidc.tsの実装詳細が未確認
  2. **main.tsの動的処理内容**：クライアント側の認証処理実装

## 2) 参照した情報（Evidence一覧）

- E-01: `ui/login.html` - 画面テンプレート
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンプレートは `ui/login.html` を使用 | E-01, E-02 | ○ |
| C-02 | ページタイトルは「SSO Etherpad」 | E-01 (7行目) | ○ |
| C-03 | ユーザー名入力欄のname属性は `login` | E-01 (16行目) | ○ |
| C-04 | パスワード入力欄のname属性は `password` | E-01 (20行目) | ○ |
| C-05 | ユーザー名入力欄にrequired属性がある | E-01 (16行目) | ○ |
| C-06 | パスワード入力欄にrequired属性がある | E-01 (20行目) | ○ |
| C-07 | パスワード表示アイコンのIDは `eye-visible` | E-01 (21行目) | ○ |
| C-08 | パスワード非表示アイコンのIDは `eye-hide` | E-01 (25行目) | ○ |
| C-09 | エラー表示領域のIDは `error` | E-01 (31行目) | ○ |
| C-10 | クライアント名表示のIDは `client` | E-01 (13行目) | ○ |
| C-11 | ログインボタンの値は「Login」 | E-01 (30行目) | ○ |
| C-12 | 関連機能No.49「ログイン認証」が主機能 | E-03 | ○ |
| C-13 | 関連機能No.48「OAuth2認証」が主機能 | E-03 | ○ |
| C-14 | 同意画面への遷移が可能 | E-04 | ○ |
| C-15 | パッド編集画面への遷移が可能（認証成功後） | E-04 | ○ |
| C-16 | main.tsがモジュールとして読み込まれる | E-01 (36行目) | ○ |
| C-17 | OIDC認証フローの詳細処理 | **根拠なし** | △ |
| C-18 | main.tsの動的処理内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- OIDC認証フローのサーバーサイド処理
  - 候補：`src/node/hooks/express/oidc.ts`
- main.tsでのクライアント側処理（パスワード表示切替など）
  - 候補：`ui/src/main.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - HTML構造と入力フィールド
- 1: 中リスク - OIDC認証フローの詳細
- 1: 中リスク - エラーハンドリングの詳細

## 6) レビュアーチェックリスト（最小）
- [ ] login.htmlのフォーム構造が設計書と一致するか確認
- [ ] 関連機能マッピングが画面機能マッピング.csvと一致するか確認
- [ ] oidc.ts を調査し、認証フローの詳細を追記するか検討
- [ ] main.ts を調査し、クライアント側処理の詳細を追記するか検討
