---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：7-プラグイン管理画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **installer.tsの詳細実装**：npm操作の詳細処理
  2. **更新確認ロジック（checkUpdates）の詳細**：semverバージョン比較

## 2) 参照した情報（Evidence一覧）

- E-01: `admin/src/pages/HomePage.tsx` - プラグイン管理画面コンポーネント
- E-02: `admin/src/pages/Plugin.ts` - プラグイン型定義
- E-03: `admin/src/store/store.ts` - 状態管理ストア
- E-04: `src/node/hooks/express/adminplugins.ts` - WebSocketハンドラー
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンポーネントは `HomePage.tsx` | E-01, E-05 | ○ |
| C-02 | WebSocket名前空間は `/pluginfw/installer` | E-04 (18行目) | ○ |
| C-03 | PluginDef型でname, description, version, time, officialを定義 | E-02 (1-7行目) | ○ |
| C-04 | InstalledPlugin型でname, path, realPath, version, updatableを定義 | E-02 (10-16行目) | ○ |
| C-05 | SearchParams型で検索パラメータを定義 | E-02 (19-25行目) | ○ |
| C-06 | pluginsSocketをストアで管理 | E-03 (21行目, 39行目) | ○ |
| C-07 | installedPluginsをストアで管理 | E-03 (27-28行目, 50-51行目) | ○ |
| C-08 | results:installedイベントでインストール済み受信 | E-01 (75-78行目), E-04 (58行目) | ○ |
| C-09 | results:updatableイベントで更新可能情報受信 | E-01 (81-91行目), E-04 (67行目) | ○ |
| C-10 | finished:installイベントでインストール完了通知 | E-01 (94-96行目), E-04 (106-111行目) | ○ |
| C-11 | finished:uninstallイベントでアンインストール完了通知 | E-01 (98-100行目), E-04 (119行目) | ○ |
| C-12 | searchイベントで検索リクエスト | E-01 (127行目), E-04 (86-100行目) | ○ |
| C-13 | installイベントでインストールリクエスト | E-01 (150行目), E-04 (102-112行目) | ○ |
| C-14 | uninstallイベントでアンインストールリクエスト | E-01 (144行目), E-04 (115-121行目) | ○ |
| C-15 | getInstalledイベントでインストール済み取得 | E-01 (106行目, 110行目), E-04 (47-59行目) | ○ |
| C-16 | 検索に500msデバウンスを適用 | E-01 (154-160行目) | ○ |
| C-17 | 5分ごとに更新確認を実行 | E-01 (113-115行目) | ○ |
| C-18 | ep_etherpad-liteはアンインストール不可 | E-01 (185行目 disabled条件) | ○ |
| C-19 | プラグイン名はnpmjs.comへのリンク | E-01 (179行目, 231行目) | ○ |
| C-20 | インストール済みテーブルのIDは `installed-plugins` | E-01 (168行目) | ○ |
| C-21 | 利用可能テーブルのIDは `available-plugins` | E-01 (198行目) | ○ |
| C-22 | Trashアイコンでアンインストール | E-01 (7行目 import, 185行目) | ○ |
| C-23 | Downloadアイコンでインストール | E-01 (7行目 import, 236行目) | ○ |
| C-24 | ArrowUpFromDotアイコンで更新 | E-01 (7行目 import, 184行目) | ○ |
| C-25 | 管理者権限チェックを実行 | E-04 (20-22行目) | ○ |
| C-26 | ソート対象: name, version, last-updated | E-01 (201-223行目) | ○ |
| C-27 | 関連機能No.61「プラグイン管理」が主機能 | E-06 | ○ |
| C-28 | 検索結果エラー時にトースト通知 | E-01 (133-139行目) | ○ |
| C-29 | installer.tsの詳細実装 | **根拠なし** | △ |
| C-30 | checkUpdatesの詳細ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- installer.tsでのnpmパッケージ操作の詳細
  - 候補：`src/static/js/pluginfw/installer.ts`
- checkUpdatesでのバージョン比較ロジック
  - 候補：`src/node/hooks/express/adminplugins.ts` の checkPluginForUpdates 関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Reactコンポーネント構造
- 0: 低リスク - WebSocketイベント処理
- 1: 中リスク - npm操作の詳細処理

## 6) レビュアーチェックリスト（最小）
- [ ] HomePage.tsxのWebSocketイベント処理が設計書と一致するか確認
- [ ] adminplugins.tsのイベントハンドラーが正しく動作するか確認
- [ ] installer.ts を調査し、npm操作の詳細を追記するか検討
- [ ] 関連機能マッピングが画面機能マッピング.csvと一致するか確認
