---
generated_at: 2026-02-10 11:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：9-ヘルプ/情報画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **UpdateCheck.tsの詳細実装**：最新バージョン取得の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `admin/src/pages/HelpPage.tsx` - ヘルプ画面コンポーネント
- E-02: `admin/src/pages/Plugin.ts` - HelpObj型定義
- E-03: `admin/src/store/store.ts` - 状態管理ストア
- E-04: `src/node/hooks/express/adminsettings.ts` - WebSocketハンドラー
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンポーネントは `HelpPage.tsx` | E-01, E-05 | ○ |
| C-02 | WebSocket名前空間は `/settings` | E-04 (22行目) | ○ |
| C-03 | HelpObj型でヘルプデータを管理 | E-01 (8行目), E-02 (28-36行目) | ○ |
| C-04 | useStateでhelpDataを管理 | E-01 (8行目) | ○ |
| C-05 | reply:helpイベントでデータ受信 | E-01 (12-13行目), E-04 (94行目) | ○ |
| C-06 | helpイベントでリクエスト送信 | E-01 (16行目), E-04 (75行目) | ○ |
| C-07 | renderHooks関数でフック階層表示 | E-01 (19-31行目) | ○ |
| C-08 | helpDataがnullで空div返却 | E-01 (35行目) | ○ |
| C-09 | epVersionをhelpDataから表示 | E-01 (41行目) | ○ |
| C-10 | latestVersionをhelpDataから表示 | E-01 (43行目) | ○ |
| C-11 | gitCommitをhelpDataから表示 | E-01 (45行目) | ○ |
| C-12 | installedPluginsをリスト表示 | E-01 (48-49行目) | ○ |
| C-13 | installedPartsをリスト表示 | E-01 (53-54行目) | ○ |
| C-14 | installedServerHooksをrenderHooksで表示 | E-01 (58-59行目) | ○ |
| C-15 | installedClientHooksをrenderHooksで表示 | E-01 (64-65行目) | ○ |
| C-16 | getGitCommit()で取得 | E-04 (76行目) | ○ |
| C-17 | getEpVersion()で取得 | E-04 (77行目) | ○ |
| C-18 | plugins.getHooks()でフック取得 | E-04 (79-80行目) | ○ |
| C-19 | 関連機能No.64「統計情報取得」が主機能 | E-06 | ○ |
| C-20 | UpdateCheck.tsの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- UpdateCheck.tsでの最新バージョン取得の詳細
  - 候補：`src/node/utils/UpdateCheck.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Reactコンポーネント構造
- 0: 低リスク - 情報表示処理

## 6) レビュアーチェックリスト（最小）
- [ ] HelpPage.tsxの処理フローが設計書と一致するか確認
- [ ] adminsettings.tsのhelpイベントハンドラーが正しく動作するか確認
- [ ] Plugin.ts の HelpObj型がサーバー応答と一致するか確認
- [ ] 関連機能マッピングが画面機能マッピング.csvと一致するか確認
