---
generated_at: 2026-02-10 14:50:00
metrics:
  claims_total: 100
  claims_with_evidence: 100
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：100 / 100、根拠なし：0
- 優先レビュー（高）
  1. **全テストケースに根拠あり**：既存テストコードから抽出
  2. **テスト手順の詳細**：実際のテストコードとの整合性確認推奨
  3. **期待結果の網羅性**：エッジケースの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tests/backend/specs/api/api.ts` - API基盤テスト
- E-02: `src/tests/backend/specs/api/pad.ts` - Pad管理APIテスト
- E-03: `src/tests/backend/specs/api/sessionsAndGroups.ts` - セッション・グループAPIテスト
- E-04: `src/tests/backend/specs/api/chat.ts` - チャットAPIテスト
- E-05: `src/tests/backend/specs/api/restoreRevision.ts` - リビジョン復元テスト
- E-06: `src/tests/backend/specs/api/importexport.ts` - インポート/エクスポートテスト
- E-07: `src/tests/backend/specs/socketio.ts` - Socket.IO連携テスト
- E-08: `src/tests/backend/specs/health.ts` - ヘルスチェックテスト
- E-09: `src/tests/backend/specs/webaccess.ts` - Webアクセス・認証テスト
- E-10: `src/tests/backend/specs/Pad.ts` - Padデータベース連携テスト
- E-11: `src/node/db/API.ts` - APIエンドポイント定義
- E-12: `src/node/db/PadManager.ts` - Pad管理モジュール
- E-13: `src/node/handler/ImportHandler.ts` - インポートハンドラー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: APIバージョン取得テスト | E-01 | ○ |
| C-02 | IT-002: OpenAPI定義取得テスト | E-01 | ○ |
| C-03 | IT-003: Pad作成テスト | E-02, E-11 | ○ |
| C-04 | IT-004: Pad削除テスト | E-02, E-11 | ○ |
| C-05 | IT-005: Padテキスト取得テスト | E-02, E-11 | ○ |
| C-06 | IT-006: Padテキスト設定テスト | E-02, E-11 | ○ |
| C-07 | IT-007: PadHTML取得テスト | E-02, E-11 | ○ |
| C-08 | IT-008: PadHTML設定テスト | E-02, E-11 | ○ |
| C-09 | IT-009: リビジョン数取得テスト | E-02, E-11 | ○ |
| C-10 | IT-010: リビジョン保存テスト | E-02, E-11 | ○ |
| C-11 | IT-011: 保存済みリビジョン数取得テスト | E-02, E-11 | ○ |
| C-12 | IT-012: 保存済みリビジョン一覧取得テスト | E-02, E-11 | ○ |
| C-13 | IT-013: 全Pad一覧取得テスト | E-02, E-12 | ○ |
| C-14 | IT-014: Padユーザー数取得テスト | E-02, E-11 | ○ |
| C-15 | IT-015: 読み取り専用ID取得テスト | E-02, E-11 | ○ |
| C-16 | IT-016: Pad著者一覧取得テスト | E-02, E-11 | ○ |
| C-17 | IT-017: 最終編集日時取得テスト | E-02, E-11 | ○ |
| C-18 | IT-018: Pad移動テスト | E-02, E-11 | ○ |
| C-19 | IT-019: Padコピーテスト | E-02, E-11 | ○ |
| C-20 | IT-020: 履歴なしPadコピーテスト | E-02, E-11 | ○ |
| C-21 | IT-021: テキスト追記テスト | E-02, E-11 | ○ |
| C-22 | IT-022: 旧リビジョンテキスト取得テスト | E-02, E-11 | ○ |
| C-23 | IT-023: リビジョン復元テスト | E-05, E-11 | ○ |
| C-24 | IT-024: リビジョン復元（著者ID付き）テスト | E-05, E-11 | ○ |
| C-25 | IT-025: グループ作成テスト | E-03, E-11 | ○ |
| C-26 | IT-026: グループ削除テスト | E-03, E-11 | ○ |
| C-27 | IT-027: グループ存在確認作成テスト | E-03, E-11 | ○ |
| C-28 | IT-028: グループPad作成テスト | E-03, E-11 | ○ |
| C-29 | IT-029: グループPad一覧取得テスト | E-03, E-11 | ○ |
| C-30 | IT-030: 著者作成テスト | E-03, E-11 | ○ |
| C-31 | IT-031: 著者作成（名前付き）テスト | E-03, E-11 | ○ |
| C-32 | IT-032: 著者存在確認作成テスト | E-03, E-11 | ○ |
| C-33 | IT-033: 著者名取得テスト | E-03, E-11 | ○ |
| C-34 | IT-034: 著者Pad一覧取得テスト | E-03, E-11 | ○ |
| C-35 | IT-035: セッション作成テスト | E-03, E-11 | ○ |
| C-36 | IT-036: セッション情報取得テスト | E-03, E-11 | ○ |
| C-37 | IT-037: グループセッション一覧取得テスト | E-03, E-11 | ○ |
| C-38 | IT-038: セッション削除テスト | E-03, E-11 | ○ |
| C-39 | IT-039: 削除済みセッション情報取得テスト | E-03, E-11 | ○ |
| C-40 | IT-040: 公開ステータス取得テスト | E-03, E-11 | ○ |
| C-41 | IT-041: 公開ステータス設定テスト | E-03, E-11 | ○ |
| C-42 | IT-042: チャットメッセージ追加テスト | E-04, E-11 | ○ |
| C-43 | IT-043: チャットヘッド取得テスト | E-04, E-11 | ○ |
| C-44 | IT-044: チャット履歴取得テスト | E-04, E-11 | ○ |
| C-45 | IT-045: 無効なOAuthトークンテスト | E-02 | ○ |
| C-46 | IT-046: HTMLインポートテスト | E-06, E-13 | ○ |
| C-47 | IT-047: HTMLエクスポートテスト | E-06, E-11 | ○ |
| C-48 | IT-048: テキストエクスポートテスト | E-06, E-11 | ○ |
| C-49 | IT-049: ネストリストHTML処理テスト | E-06 | ○ |
| C-50 | IT-050: スペース処理テスト | E-06 | ○ |
| C-51 | IT-051: 改行処理テスト | E-06 | ○ |
| C-52 | IT-052: 非改行スペース処理テスト | E-06 | ○ |
| C-53 | IT-053: preタグ処理テスト | E-06 | ○ |
| C-54 | IT-054: 匿名Cookie接続テスト | E-07 | ○ |
| C-55 | IT-055: Cookie無し接続テスト | E-07 | ○ |
| C-56 | IT-056: 認証ユーザー接続テスト | E-07 | ○ |
| C-57 | IT-057: 読み取り専用Pad接続テスト | E-07 | ○ |
| C-58 | IT-058: 匿名接続拒否テスト | E-07 | ○ |
| C-59 | IT-059: 認可バイパス試行テスト | E-07 | ○ |
| C-60 | IT-060: パーセントエンコード対応テスト | E-07 | ○ |
| C-61 | IT-061: create権限テスト | E-07 | ○ |
| C-62 | IT-062: modify権限テスト | E-07 | ○ |
| C-63 | IT-063: readOnly権限テスト | E-07 | ○ |
| C-64 | IT-064: editOnly設定テスト | E-07 | ○ |
| C-65 | IT-065: setSocketIOコールバックテスト | E-07 | ○ |
| C-66 | IT-066: handleConnectコールバックテスト | E-07 | ○ |
| C-67 | IT-067: handleDisconnectコールバックテスト | E-07 | ○ |
| C-68 | IT-068: handleMessageコールバックテスト | E-07 | ○ |
| C-69 | IT-069: ヘルスエンドポイントテスト | E-08 | ○ |
| C-70 | IT-070: 認証不要確認テスト | E-08 | ○ |
| C-71 | IT-071: Cookie無し確認テスト | E-08 | ○ |
| C-72 | IT-072: 匿名アクセス許可テスト | E-09 | ○ |
| C-73 | IT-073: 匿名管理画面アクセス拒否テスト | E-09 | ○ |
| C-74 | IT-074: 認証必須匿名アクセス拒否テスト | E-09 | ○ |
| C-75 | IT-075: 認証ユーザーアクセス許可テスト | E-09 | ○ |
| C-76 | IT-076: 非管理者管理画面アクセス拒否テスト | E-09 | ○ |
| C-77 | IT-077: 管理者アクセス許可テスト | E-09 | ○ |
| C-78 | IT-078: 管理者管理画面アクセス許可テスト | E-09 | ○ |
| C-79 | IT-079: 認可必須robots.txt許可テスト | E-09 | ○ |
| C-80 | IT-080: 認可必須一般ユーザー拒否テスト | E-09 | ○ |
| C-81 | IT-081: 認可必須管理者許可テスト | E-09 | ○ |
| C-82 | IT-082: preAuthorize遅延処理テスト | E-09 | ○ |
| C-83 | IT-083: preAuthorize許可バイパステスト | E-09 | ○ |
| C-84 | IT-084: preAuthorize拒否バイパステスト | E-09 | ○ |
| C-85 | IT-085: 静的コンテンツバイパステスト | E-09 | ○ |
| C-86 | IT-086: authenticate遅延処理テスト | E-09 | ○ |
| C-87 | IT-087: authenticate成功処理テスト | E-09 | ○ |
| C-88 | IT-088: authenticate失敗処理テスト | E-09 | ○ |
| C-89 | IT-089: authorize遅延処理テスト | E-09 | ○ |
| C-90 | IT-090: authorize成功処理テスト | E-09 | ○ |
| C-91 | IT-091: authorize失敗処理テスト | E-09 | ○ |
| C-92 | IT-092: authnFailureハンドルテスト | E-09 | ○ |
| C-93 | IT-093: authzFailureハンドルテスト | E-09 | ○ |
| C-94 | IT-094: authFailureハンドルテスト | E-09 | ○ |
| C-95 | IT-095: Pad初期化テスト | E-10, E-12 | ○ |
| C-96 | IT-096: Pad存在確認テスト | E-10, E-12 | ○ |
| C-97 | IT-097: padDefaultContent Hookテスト | E-10 | ○ |
| C-98 | IT-098: 初期テキスト指定Pad作成テスト | E-10, E-12 | ○ |
| C-99 | IT-099: 著者ID指定Pad作成テスト | E-10, E-12 | ○ |
| C-100 | IT-100: cleanText改行正規化テスト | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースがソースコードから直接抽出されているため、根拠なしの項目はありません
  - 候補：フロントエンドE2Eテスト / パフォーマンステスト / 負荷テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースが既存テストコードから抽出されており、実装との整合性が高い
- 追加検討事項：
  - フロントエンド結合テスト（Playwright/Cypressテスト）の別途ドキュメント化
  - 外部サービス連携（LibreOffice/Abiword変換）のテストは環境依存のため除外

## 6) レビュアーチェックリスト（最小）
- [ ] テストID（IT-xxx）が一意であることを確認
- [ ] テスト種別の分類が適切か確認
- [ ] 前提条件が実行可能な状態を正しく記述しているか確認
- [ ] テスト手順が再現可能な具体性を持っているか確認
- [ ] 期待結果が検証可能な形で記述されているか確認
- [ ] 優先度（高/中/低）の設定が適切か確認
- [ ] 備考欄のソースファイル参照が正しいか確認
