---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 33
  claims_with_evidence: 33
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：33 / 33、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_connectionstatus.ts`
- E-02: `src/static/js/pad_modals.ts`
- E-03: `src/templates/pad.html`
- E-04: `src/static/js/chat.ts`
- E-05: `src/static/js/pad_savedrevs.ts`
- E-06: `src/static/js/pad_impexp.ts`
- E-07: `src/static/js/pad_cookie.ts`
- E-08: `src/static/js/pad_utils.ts`
- E-09: `src/static/js/ace2_inner.ts`
- E-10: `src/static/js/pad.ts`
- E-11: `src/static/js/vendors/gritter.ts`
- E-12: `src/locales/en.json`
- E-13: `admin/src/pages/SettingsPage.tsx`
- E-14: `admin/src/pages/LoginScreen.tsx`
- E-15: `admin/src/pages/HomePage.tsx`
- E-16: `admin/src/pages/PadPage.tsx`
- E-17: `admin/src/utils/Toast.tsx`
- E-18: `admin/src/store/store.ts`
- E-19: `src/static/js/pad_automatic_reconnect.ts`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | connected通知 | E-01, E-02, E-03 | ○ |
| C-02 | reconnecting通知 | E-01, E-02, E-03 | ○ |
| C-03 | disconnected通知 | E-01, E-02, E-03, E-19 | ○ |
| C-04 | userdup通知 | E-01, E-03, E-12 | ○ |
| C-05 | unauth通知 | E-01, E-03, E-12 | ○ |
| C-06 | looping通知 | E-01, E-03, E-12 | ○ |
| C-07 | initsocketfail通知 | E-01, E-03, E-12 | ○ |
| C-08 | slowcommit通知 | E-01, E-03, E-12, E-19 | ○ |
| C-09 | badChangeset通知 | E-01, E-03, E-12, E-19 | ○ |
| C-10 | corruptPad通知 | E-01, E-03, E-12 | ○ |
| C-11 | deleted通知 | E-01, E-03, E-12 | ○ |
| C-12 | rateLimited通知 | E-01, E-03, E-12 | ○ |
| C-13 | rejected通知 | E-01, E-03, E-12 | ○ |
| C-14 | チャットメッセージ通知 | E-04, E-11 | ○ |
| C-15 | チャットメンション通知 | E-04 | ○ |
| C-16 | リビジョン保存通知 | E-05, E-11, E-12 | ○ |
| C-17 | インポート成功通知 | E-06, E-03 | ○ |
| C-18 | インポート失敗通知 | E-06, E-12 | ○ |
| C-19 | convertFailed通知 | E-06, E-12 | ○ |
| C-20 | uploadFailed通知 | E-06, E-12 | ○ |
| C-21 | padHasData通知 | E-06, E-12 | ○ |
| C-22 | maxFileSize通知 | E-06, E-12 | ○ |
| C-23 | エクスポート無効通知 | E-06, E-12 | ○ |
| C-24 | Cookieエラー通知 | E-07, E-11, E-12 | ○ |
| C-25 | JavaScriptエラー通知 | E-08, E-11 | ○ |
| C-26 | 行作者情報通知 | E-09, E-11 | ○ |
| C-27 | 管理者メッセージ通知 | E-10, E-11 | ○ |
| C-28 | 設定保存成功通知 | E-13, E-17, E-18 | ○ |
| C-29 | 設定保存エラー通知 | E-13, E-17, E-18 | ○ |
| C-30 | ログイン失敗通知 | E-14, E-17, E-18 | ○ |
| C-31 | プラグイン検索エラー通知 | E-15, E-17, E-18 | ○ |
| C-32 | パッド作成成功通知 | E-16, E-17, E-18 | ○ |
| C-33 | パッド作成エラー通知 | E-16, E-17, E-18 | ○ |

## 4) 不足情報（Unknown / Missing）

- 不足情報なし
  - 全ての通知はソースコードとロケールファイルから確認できました

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての通知は実際のソースコードから抽出しており、信頼性は高いです
- 注意点：
  - プラグインによる追加通知は本一覧に含まれていません
  - カスタムスキンによる通知の変更は考慮されていません

## 6) レビュアーチェックリスト（最小）

- [ ] 各通知のカテゴリ分類が適切か確認
- [ ] 通知名がソースコード上の識別子と一致しているか確認
- [ ] 説明文が実際の動作を正確に反映しているか確認
- [ ] 備考欄のファイルパスが正しいか確認
- [ ] プラグインによる追加通知がないか確認（必要に応じて追記）
