# 通知設計書 1-connected

## 概要

本ドキュメントは、Etherpadにおけるサーバー接続完了通知（connected）の設計を記述する。

### 本通知の処理概要

この通知はサーバーへの接続が確立されたことをユーザーに知らせるモーダルダイアログを表示する機能である。接続成功時にツールバーのオーバーレイを解除し、ユーザーがパッドの編集を継続できる状態にする。

**業務上の目的・背景**：リアルタイム共同編集アプリケーションであるEtherpadでは、サーバーとの常時接続が必須である。接続状態の変化をユーザーに明確に通知することで、編集作業の継続可否を判断できるようにし、データ損失のリスクを軽減する。再接続後に正常に接続が確立されたことを通知することで、ユーザーに安心感を与える。

**通知の送信タイミング**：WebSocket経由でサーバーとの接続が確立され、collabClientのチャンネル状態が「CONNECTED」に変更されたときにトリガーされる。初回接続時および再接続成功時の両方で発火する。

**通知の受信者**：通知は接続を確立したユーザー本人のブラウザ上でのみ表示される。他のユーザーには通知されない。ローカルのUI通知であり、サーバーからの通知ではない。

**通知内容の概要**：「Connected.」という短いメッセージがモーダルに表示される。このメッセージは国際化対応されており、ユーザーの言語設定に応じて翻訳される。

**期待されるアクション**：ユーザーは通知を確認後、パッドの編集を継続する。モーダルは自動的に閉じられるため、特別な操作は不要である。

## 通知種別

アプリ内通知（モーダルダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし（ローカル表示のため） |

### 送信先決定ロジック

接続を確立した現在のブラウザセッションのユーザーに対してのみ表示される。サーバー側での送信先決定は行わない。

## 通知テンプレート

### モーダル通知の場合

| 項目 | 内容 |
|-----|------|
| 表示要素 | `#connectivity .connected` |
| タイトル | なし（h2要素でメッセージを表示） |
| メッセージ | Connected. |

### 本文テンプレート

```html
<div class="connected visible">
  <h2 data-l10n-id="pad.modals.connected"></h2>
</div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | この通知には変数がない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| WebSocket接続 | CONNECTED状態への遷移 | channelStateが'CONNECTED'に変更 | collabClientのsetChannelState関数が'CONNECTED'で呼び出された時 |
| 再接続成功 | socket.io reconnectイベント | 再接続が成功した場合 | socket.ioの自動再接続が成功した時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に接続済み | 現在の状態がすでに'connected'の場合、重複表示しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[WebSocket接続確立] --> B[handleChannelStateChange呼び出し]
    B --> C{newState === 'CONNECTED'?}
    C -->|Yes| D[padeditor.enable]
    D --> E[padeditbar.enable]
    E --> F[padimpexp.enable]
    F --> G[padconnectionstatus.connected]
    G --> H[padmodals.showModal 'connected']
    H --> I[padmodals.hideOverlay]
    I --> J[モーダル表示]
    J --> K[1秒後にモーダル自動非表示]
    C -->|No| L[他の状態処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | ローカルUI処理のみ | データベースアクセスなし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | データベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| DOM要素不在 | connectivity要素が存在しない場合 | エラーは発生するがユーザー操作には影響なし |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 通知はローカルブラウザ内でのみ処理される
- ユーザー認証情報は通知内容に含まれない
- XSS対策としてdata-l10n-id属性による国際化を使用

## 備考

- 通知表示後、約1秒後に`padeditbar.toggleDropDown('none')`により自動的にモーダルが閉じられる
- 国際化対応: pad.modals.connectedキーで翻訳される
- スキンのカスタマイズにより表示スタイルを変更可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

通知の状態管理で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | status変数の構造（what, why）を理解する（29-31行目） |

**読解のコツ**: TypeScriptの即時実行関数パターン（IIFE）でモジュールが構成されている。selfオブジェクトがエクスポートされるpublicメソッドを持つ。

#### Step 2: エントリーポイントを理解する

通知がトリガーされる起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pad.ts | `src/static/js/pad.ts` | handleChannelStateChange関数（651-693行目）がconnected通知のエントリーポイント |

**主要処理フロー**:
1. **651行目**: handleChannelStateChangeが呼び出される
2. **654行目**: newStateが'CONNECTED'の場合の分岐
3. **658行目**: padconnectionstatus.connected()を呼び出し

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | connected関数（39-45行目）の実装を確認 |
| 3-2 | pad_modals.ts | `src/static/js/pad_modals.ts` | showModal関数（35-43行目）でモーダル表示の仕組みを理解 |

**主要処理フロー**:
- **39-42行目（pad_connectionstatus.ts）**: statusを更新しconnectedに設定
- **43行目**: padmodals.showModal('connected')を呼び出し
- **44行目**: padmodals.hideOverlay()でオーバーレイを解除
- **36-38行目（pad_modals.ts）**: CSS classの切り替えでモーダルを表示

#### Step 4: HTMLテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad.html | `src/templates/pad.html` | connectivity divの構造（242-318行目）を確認 |

**主要処理フロー**:
- **244-246行目**: connected用のdiv要素とメッセージ

### プログラム呼び出し階層図

```
pad.handleChannelStateChange (pad.ts:651)
    │
    ├─ padconnectionstatus.connected (pad_connectionstatus.ts:39)
    │      ├─ padmodals.showModal('connected') (pad_modals.ts:35)
    │      │      ├─ padeditbar.toggleDropDown('none') (pad_editbar.ts)
    │      │      ├─ $('#connectivity .visible').removeClass('visible')
    │      │      ├─ $('#connectivity .connected').addClass('visible')
    │      │      └─ padeditbar.toggleDropDown('connectivity')
    │      │
    │      └─ padmodals.hideOverlay (pad_modals.ts:49)
    │             └─ $('#toolbar-overlay').hide()
    │
    └─ handleIsFullyConnected (pad.ts:694)
           └─ padeditbar.toggleDropDown('none') (1秒後に実行)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

WebSocket                collab_client.ts               pad.ts
接続確立         ──▶     setChannelState('CONNECTED')   handleChannelStateChange
                              │                              │
                              ▼                              ▼
                         callbacks.onChannelStateChange  padconnectionstatus.connected
                                                              │
                                                              ▼
                                                         pad_modals.showModal
                                                              │
                                                              ▼
                                                         DOMクラス切り替え
                                                         (#connectivity .connected)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pad.ts | `src/static/js/pad.ts` | ソース | メインのパッドモジュール、イベントハンドラ |
| pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | ソース | 接続状態管理モジュール |
| pad_modals.ts | `src/static/js/pad_modals.ts` | ソース | モーダル表示制御モジュール |
| collab_client.ts | `src/static/js/collab_client.ts` | ソース | WebSocket通信とリアルタイム同期 |
| pad.html | `src/templates/pad.html` | テンプレート | パッドのHTMLテンプレート |
| en.json | `src/locales/en.json` | 設定 | 国際化リソース（英語） |
| pad.css | `src/static/css/pad.css` | スタイル | モーダルのスタイル定義 |
