# 通知設計書 10-corruptPad

## 概要

本ドキュメントは、Etherpadにおけるパッド破損通知（corruptPad）の設計を記述する。

### 本通知の処理概要

この通知はアクセスしようとしているパッドが破損していることをユーザーに知らせるモーダルダイアログを表示する機能である。サーバー設定の問題や予期しない動作によってパッドデータが破損した場合に表示される。自動復旧の手段はなく、サービス管理者への連絡が推奨される。

**業務上の目的・背景**：Etherpadはパッドデータをサーバーに保存し、すべてのリビジョン履歴を管理する。何らかの理由でパッドデータが破損した場合、正常に読み込むことができなくなる。この通知により、ユーザーにパッドの状態を知らせ、サービス管理者への連絡を促すことで、データ復旧やバックアップからの復元などの対応を取ることができる。

**通知の送信タイミング**：サーバーがパッドデータの読み込みに失敗し、「corruptPad」理由で切断を通知した時にトリガーされる。

**通知の受信者**：破損したパッドにアクセスしようとしたユーザーに対して表示される。

**通知内容の概要**：「You have been disconnected.」というタイトルと、「The pad you are trying to access is corrupt.」という説明、「This may be due to a wrong server configuration or some other unexpected behavior. Please contact the service administrator.」という原因説明が表示される。

**期待されるアクション**：ユーザーはサービス管理者に連絡し、パッドの復旧を依頼する。自動再接続や手動再接続による復旧は期待できない。

## 通知種別

アプリ内通知（モーダルダイアログ + オーバーレイ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし（パッド破損のため再接続しても復旧しない） |

### 送信先決定ロジック

破損したパッドにアクセスしようとしたセッションのブラウザに対してのみ表示される。

## 通知テンプレート

### モーダル通知の場合

| 項目 | 内容 |
|-----|------|
| 表示要素 | `#connectivity .corruptPad` |
| タイトル | You have been disconnected. |
| 説明 | The pad you are trying to access is corrupt. |
| 原因 | This may be due to a wrong server configuration or some other unexpected behavior. Please contact the service administrator. |

### 本文テンプレート

```html
<div class="corruptPad">
  <h1 data-l10n-id="pad.modals.disconnected"></h1>
  <h2 data-l10n-id="pad.modals.corruptPad.explanation"></h2>
  <p data-l10n-id="pad.modals.corruptPad.cause"></p>
</div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | この通知には変数がない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバー通知 | message.disconnect='corruptPad' | パッドデータ破損 | サーバーがパッドの読み込みに失敗して切断を指示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に切断状態 | status.whatが'disconnected'の場合は重複処理しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[サーバーから切断メッセージ受信] --> B{message.disconnect === 'corruptPad'?}
    B -->|Yes| C[padconnectionstatus.disconnected 'corruptPad']
    C --> D[statusを'disconnected'に更新]
    D --> E[knownReasonsに'corruptPad'が含まれる]
    E --> F[padmodals.showModal 'corruptPad']
    F --> G[padmodals.showOverlay]
    G --> H[モーダル・オーバーレイ表示]
    H --> I[ユーザーはサービス管理者に連絡]
    B -->|No| J[他の切断理由の処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | クライアント側はローカルUI処理のみ | サーバー側でパッドデータを参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | クライアント側でのデータベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| パッドデータ破損 | パッドの内部データが壊れている | サービス管理者がバックアップから復元 |
| リビジョン不整合 | リビジョン履歴が不整合 | サービス管理者が修復ツールを使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 通知はローカルブラウザ内でのみ処理される
- パッド破損の詳細な原因はクライアントには表示されない
- サービス管理者への連絡を促すことで適切な対応を促進

## 備考

- corruptPadはknownReasons配列に含まれており、専用モーダルが表示される
- Force reconnectボタンは表示されない（再接続しても復旧しないため）
- 自動再接続タイマー（with_reconnect_timer）は付与されていない
- 国際化対応: pad.modals.disconnected, pad.modals.corruptPad.explanation, pad.modals.corruptPad.causeキーで翻訳
- サービス管理者はサーバーログを確認し、パッド修復ツールの使用やバックアップからの復元を検討する必要がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

corruptPad通知で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | knownReasons配列に'corruptPad'が含まれていることを確認（67行目） |

**読解のコツ**: corruptPadはknownReasonsの一つであり、専用のモーダルが表示される。

#### Step 2: エントリーポイントを理解する

サーバーからの切断通知を受け取る起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pad.ts | `src/static/js/pad.ts` | socket.on('message')でのdisconnect処理（333-342行目） |

**主要処理フロー**:
1. **333行目**: obj.disconnectが存在するかチェック
2. **334行目**: padconnectionstatus.disconnected(obj.disconnect)を呼び出し

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | disconnected関数でのknownReasons判定（79行目） |
| 3-2 | pad_modals.ts | `src/static/js/pad_modals.ts` | showModal関数（35-43行目） |

**主要処理フロー**:
- **67行目**: knownReasonsに'corruptPad'が含まれる
- **79行目**: msgが'corruptPad'の場合、kはそのまま'corruptPad'になる
- **84行目**: padmodals.showModal('corruptPad')が呼び出される

#### Step 4: HTMLテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad.html | `src/templates/pad.html` | corruptPad divの構造（286-290行目） |

**主要処理フロー**:
- **286行目**: with_reconnect_timerクラスなし
- **286-290行目**: Force reconnectボタンなし

### プログラム呼び出し階層図

```
socket.on('message') (pad.ts:303)
    │
    └─ obj.disconnect === 'corruptPad'
           │
           └─ padconnectionstatus.disconnected('corruptPad') (pad_connectionstatus.ts:54)
                  ├─ status = { what: 'disconnected', why: 'corruptPad' }
                  ├─ knownReasons.indexOf('corruptPad') !== -1 → k = 'corruptPad'
                  ├─ padmodals.showModal('corruptPad') (pad_modals.ts:35)
                  │      ├─ padeditbar.toggleDropDown('none')
                  │      ├─ $('#connectivity .visible').removeClass('visible')
                  │      ├─ $('#connectivity .corruptPad').addClass('visible')
                  │      └─ padeditbar.toggleDropDown('connectivity')
                  │
                  └─ padmodals.showOverlay (pad_modals.ts:45)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

サーバー                  pad.ts                        pad_connectionstatus.ts
disconnect=           ──▶ socket.on('message')          disconnected('corruptPad')
'corruptPad'               │                              │
                              ▼                              ▼
                         obj.disconnect検出              knownReasons判定
                              │                         k = 'corruptPad'
                              ▼                              │
                         padconnectionstatus                 ▼
                         .disconnected                  padmodals.showModal
                                                              │
                                                              ▼
                                                        モーダル表示
                                                        (#connectivity .corruptPad)
                                                        ※再接続ボタンなし
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pad.ts | `src/static/js/pad.ts` | ソース | メインモジュール、メッセージハンドラ |
| pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | ソース | 接続状態管理、切断理由判定 |
| pad_modals.ts | `src/static/js/pad_modals.ts` | ソース | モーダル表示制御 |
| pad.html | `src/templates/pad.html` | テンプレート | HTMLテンプレート |
| en.json | `src/locales/en.json` | 設定 | 国際化リソース |
