# 通知設計書 17-インポート成功通知

## 概要

本ドキュメントは、Etherpadにおけるインポート成功通知の設計仕様を定義する。この通知は、ファイルのインポート処理が正常に完了した際に表示される成功メッセージである。

### 本通知の処理概要

この通知はファイルインポート操作が正常に完了したことをユーザーに伝え、インポートされた内容がパッドに反映されたことを確認できるようにするためのアプリ内表示である。

**業務上の目的・背景**：共同編集環境において、既存のドキュメントをインポートして編集を開始することは一般的なワークフローである。Word、PDF、HTMLなど様々な形式のファイルをインポートできるが、変換処理には時間がかかる場合がある。この通知により、ユーザーはインポート処理が完了し、パッド内容が更新されたことを確認できる。直接データベースアクセスでインポートされた場合（Etherpad形式）は、ページのリロードが行われる。

**通知の送信タイミング**：クライアント側でAJAXリクエストによるインポートAPIの呼び出しが成功し、レスポンスコードが0（成功）の場合に表示される。具体的には、`fileInputSubmit`関数内で非同期リクエストの完了後に処理される。ただし、現在の実装では明示的な成功メッセージ表示は行われず、インポートポップアップが閉じられることで成功が暗示される。

**通知の受信者**：インポート操作を実行したユーザー本人のみ。他のユーザーには別途パッド更新が通知される。

**通知内容の概要**：「Successful!」というメッセージが`#importmessagesuccess`要素に表示される（ただし、現在の実装ではこの要素は使用されていない）。成功時はインポートポップアップが閉じられるか、ページがリロードされる。

**期待されるアクション**：ユーザーはインポートが完了したことを確認し、パッドの編集を続行する。直接データベースアクセスの場合はページがリロードされ、新しい内容が表示される。

## 通知種別

アプリ内通知（ポップアップ自動閉鎖 / ページリロード）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（HTTP POSTレスポンス） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

インポート操作を実行したクライアントでのみローカルに処理される。サーバーからのレスポンスに基づいて表示が決定される。

## 通知テンプレート

### 成功時の処理

| 項目 | 内容 |
|-----|------|
| 条件 | code === 0 |
| 動作（通常） | #import_exportポップアップを閉じる |
| 動作（直接DB） | window.location.reload()を実行 |

### 本文テンプレート

```javascript
// インポート成功時の処理
if (code !== 0) {
  importErrorMessage(message);
} else {
  $('#import_export').removeClass('popup-show');
  if (directDatabaseAccess) window.location.reload();
}
```

### HTML要素（参考）

```html
<div class="importmessage" id="importmessagesuccess"
     data-l10n-id="pad.importExport.importSuccessful">
</div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| pad.importExport.importSuccessful | 成功メッセージ「Successful!」 | src/locales/*.json | Yes |
| directDatabaseAccess | 直接DBアクセスフラグ | サーバーレスポンス | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ユーザー操作 | Import Nowボタンクリック | ファイルが選択されていること | fileInputSubmit実行 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| code !== 0 | サーバーがエラーを返した場合は成功通知ではなくエラー通知 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Import Nowボタンクリック] --> B[確認ダイアログ]
    B -->|OK| C[ローディング表示]
    C --> D[AJAXリクエスト送信]
    D --> E[サーバー処理]
    E --> F{レスポンスコード}
    F -->|code === 0| G{directDatabaseAccess?}
    F -->|code !== 0| H[エラーメッセージ表示]
    G -->|true| I[ページリロード]
    G -->|false| J[ポップアップを閉じる]
    J --> K[パッド更新通知受信]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| pad:{padId} | 既存パッド内容確認 | 上書き前 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| pad:{padId} | UPDATE | インポートされた内容でパッドを更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 変換失敗 | ファイル形式変換エラー | importErrorMessage('convertFailed') |
| アップロード失敗 | ファイル送信エラー | importErrorMessage('uploadFailed') |
| データ存在 | パッドに既存データあり | importErrorMessage('padHasData') |
| サイズ超過 | ファイルサイズ制限超過 | importErrorMessage('maxFileSize') |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし、ユーザーが再試行） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- インポートはセッション認証されたユーザーのみ実行可能
- ファイルサイズ制限（settings.importMaxFileSize）が設定されている
- 許可されたファイル形式のみインポート可能
- 非ASCIIファイルのチェックが行われる

## 備考

- 現在の実装では`#importmessagesuccess`要素は表示されず、ポップアップが閉じられることで成功が暗示される
- Etherpad形式（.etherpad）の場合は直接DBアクセスとなり、ページリロードが必要
- 他のユーザーへはpadMessageHandler.updatePadClientsで変更が通知される
- AJAXリクエストのタイムアウトは25000ミリ秒（25秒）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、インポートAPIのレスポンス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ImportHandler.ts | `src/node/handler/ImportHandler.ts` | exports.doImport関数のレスポンス形式（249-263行目） |

**読解のコツ**: レスポンスの`{code, message, data: {directDatabaseAccess}}`構造を確認する。

#### Step 2: クライアント側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pad_impexp.ts | `src/static/js/pad_impexp.ts` | fileInputSubmit関数（49-81行目）でAJAXリクエストと結果処理 |

**主要処理フロー**:
1. **52行目**: 確認ダイアログ表示
2. **57-69行目**: AJAXリクエスト送信
3. **70-75行目**: レスポンス処理（成功/エラー分岐）

#### Step 3: サーバー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ImportHandler.ts | `src/node/handler/ImportHandler.ts` | doImport関数（82-239行目）でインポート処理全体 |

**主要処理フロー**:
- **101-114行目**: Formidableでファイル受信
- **146-157行目**: Etherpad形式の直接DBアクセス処理
- **160-177行目**: ファイル形式変換
- **210-220行目**: パッド内容更新

#### Step 4: HTML構造を確認

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad.html | `src/templates/pad.html` | インポートフォームとメッセージ要素（196-209行目） |

### プログラム呼び出し階層図

```
[Import Nowボタン]
    │
    └─ fileInputSubmit(event)
           │
           ├─ window.confirm() [確認ダイアログ]
           │
           └─ $.ajax({url: '.../import', ...})
                  │
                  ▼
           ImportHandler.doImport(req, res, padId, authorId) [サーバー]
                  │
                  ├─ Formidable.parse() [ファイル受信]
                  ├─ [ファイル形式判定]
                  │      │
                  │      ├─ [.etherpad] → importEtherpad.setPadRaw()
                  │      ├─ [.html/.htm] → importHtml.setPadHTML()
                  │      └─ [その他] → converter.convertFile() → importHtml.setPadHTML()
                  │
                  └─ res.json({code, message, data: {directDatabaseAccess}})
                         │
                         ▼
           [クライアント側レスポンス処理]
                  │
                  ├─ [code === 0 && directDatabaseAccess] → window.location.reload()
                  ├─ [code === 0] → $('#import_export').removeClass('popup-show')
                  └─ [code !== 0] → importErrorMessage(message)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ファイル選択 ───▶ Import Nowクリック ───▶ 確認ダイアログ
                                              │
                                              ▼
                                     AJAXリクエスト送信
                                              │
                                              ▼
                                     サーバー処理
                                              │
                         ┌────────────────────┴────────────────────┐
                         │                                         │
                      [成功]                                    [エラー]
                         │                                         │
              ┌──────────┴──────────┐                              │
              │                     │                              │
     [直接DBアクセス]        [通常インポート]                       │
              │                     │                              │
              ▼                     ▼                              ▼
       ページリロード     ポップアップ閉じる              エラーメッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pad_impexp.ts | `src/static/js/pad_impexp.ts` | ソース | クライアント側インポート/エクスポート処理 |
| ImportHandler.ts | `src/node/handler/ImportHandler.ts` | ソース | サーバー側インポート処理 |
| importHtml.ts | `src/node/utils/ImportHtml.ts` | ソース | HTMLインポート処理 |
| importEtherpad.ts | `src/node/utils/ImportEtherpad.ts` | ソース | Etherpad形式インポート処理 |
| pad.html | `src/templates/pad.html` | テンプレート | インポートフォームHTML |
| en.json | `src/locales/en.json` | 設定 | ローカライズ文字列 |
