# 通知設計書 18-インポート失敗通知

## 概要

本ドキュメントは、Etherpadにおけるインポート失敗通知の設計仕様を定義する。この通知は、ファイルのインポート処理が何らかの理由で失敗した際に表示されるエラーメッセージである。

### 本通知の処理概要

この通知はファイルインポート操作が失敗したことをユーザーに伝え、失敗の原因に応じた適切なエラーメッセージを表示するためのアプリ内表示である。

**業務上の目的・背景**：共同編集環境において、ファイルインポートは失敗する可能性がある操作である。ファイル形式の問題、サイズ制限超過、変換エラーなど、様々な原因で失敗しうる。この通知により、ユーザーは失敗の原因を理解し、適切な対処（別の形式で再試行、ファイルサイズの削減、手動コピーペーストなど）を取ることができる。

**通知の送信タイミング**：サーバーからのインポートAPIレスポンスでcode !== 0が返された場合、クライアント側の`importErrorMessage`関数が呼び出され、`#importmessagefail`要素にエラーメッセージが表示される。

**通知の受信者**：インポート操作を実行したユーザー本人のみ。

**通知内容の概要**：「Import failed:」というプレフィックスに続いて、具体的なエラーメッセージが表示される。エラーメッセージはエラーの種類（convertFailed, uploadFailed, padHasData, maxFileSize, permission）に応じてローカライズされた文字列が表示される。未知のエラーの場合は「Please copy paste」というメッセージが表示される。

**期待されるアクション**：ユーザーはエラーメッセージを確認し、原因に応じた対処を行う。例えば、変換失敗の場合は別の形式を試す、サイズ超過の場合はファイルを分割するなど。

## 通知種別

アプリ内通知（エラーメッセージ表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（HTTP POSTレスポンス） |
| 優先度 | 高 |
| リトライ | 無 |

### 送信先決定ロジック

インポート操作を実行したクライアントでのみローカルに処理される。サーバーからのエラーレスポンスに基づいて表示が決定される。

## 通知テンプレート

### エラーメッセージ表示

| 項目 | 内容 |
|-----|------|
| 表示要素 | #importmessagefail |
| プレフィックス | pad.impexp.importfailed（「Import failed:」） |
| エラーメッセージ | エラー種別に応じたローカライズ文字列 |
| 表示方法 | fadeIn |

### 本文テンプレート

```javascript
const importErrorMessage = (status) => {
  const known = [
    'convertFailed',
    'uploadFailed',
    'padHasData',
    'maxFileSize',
    'permission',
  ];
  const msg = html10n.get(`pad.impexp.${known.indexOf(status) !== -1 ? status : 'copypaste'}`);

  const showError = (fade) => {
    const popup = $('#importmessagefail').empty()
        .append($('<strong>')
            .css('color', 'red')
            .text(`${html10n.get('pad.impexp.importfailed')}: `))
        .append(document.createTextNode(msg));
    popup[(fade ? 'fadeIn' : 'show')]();
  };
  // ...
};
```

### HTML要素

```html
<div class="importmessage" id="importmessagefail"></div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| pad.impexp.importfailed | エラープレフィックス「Import failed」 | src/locales/*.json | Yes |
| pad.impexp.convertFailed | 変換失敗メッセージ | src/locales/*.json | Yes |
| pad.impexp.uploadFailed | アップロード失敗メッセージ | src/locales/*.json | Yes |
| pad.impexp.padHasData | データ存在エラーメッセージ | src/locales/*.json | Yes |
| pad.impexp.maxFileSize | サイズ超過メッセージ | src/locales/*.json | Yes |
| pad.impexp.copypaste | 汎用エラーメッセージ | src/locales/*.json | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバーレスポンス | code !== 0 | インポートAPIがエラーを返した場合 | importErrorMessage呼び出し |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| code === 0 | インポートが成功した場合はエラー通知なし |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[インポートリクエスト送信] --> B[サーバー処理]
    B --> C{処理結果}
    C -->|エラー| D[エラーレスポンス返却]
    D --> E[importErrorMessage呼び出し]
    E --> F{既知のエラー?}
    F -->|Yes| G[対応するローカライズメッセージ取得]
    F -->|No| H[copypaste（汎用）メッセージ取得]
    G --> I[#importmessagefailに表示]
    H --> I
    I --> J[fadeIn表示]
    C -->|成功| K[成功処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

なし（エラー時はDBアクセスせずにエラー返却）

### 更新テーブル一覧

なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 | ローカライズキー |
|----------|---------|---------|----------------|
| convertFailed | ファイル形式変換エラー | 別の形式を試すか手動コピーペースト | pad.impexp.convertFailed |
| uploadFailed | ファイルアップロードエラー | 再試行 | pad.impexp.uploadFailed |
| padHasData | パッドに既存データが10リビジョン以上 | 新しいパッドにインポート | pad.impexp.padHasData |
| maxFileSize | ファイルサイズ制限超過 | 管理者に連絡してサイズ増加を依頼 | pad.impexp.maxFileSize |
| permission | 権限エラー | 適切な権限でログイン | (なし、permissionはknown配列に含まれる) |
| その他 | 未知のエラー | 手動コピーペースト | pad.impexp.copypaste |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（ユーザーが手動で再試行） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- エラーメッセージには内部エラー詳細は含まれず、ユーザーフレンドリーなメッセージのみ表示
- サーバー側のエラーログには詳細情報が記録される
- 未知のエラーは汎用メッセージで対応（情報漏洩防止）

## 備考

- エラーメッセージは赤色で強調表示される
- 既存のメッセージが表示されている場合はfadeOutしてから新しいメッセージをfadeIn
- サーバー側でImportError例外がスローされ、statusプロパティでエラー種別を識別
- settings.importMaxFileSizeでファイルサイズ制限を設定可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ImportError例外クラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ImportHandler.ts | `src/node/handler/ImportHandler.ts` | ImportErrorクラス定義（39-49行目）のstatus属性 |

**読解のコツ**: statusプロパティがどのようにエラー種別を識別するかを確認する。

#### Step 2: クライアント側の表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pad_impexp.ts | `src/static/js/pad_impexp.ts` | importErrorMessage関数（83-108行目）でエラー表示処理 |

**主要処理フロー**:
1. **84-90行目**: known配列で既知のエラー種別を定義
2. **91行目**: ローカライズキーの決定（known配列に含まれるか判定）
3. **93-99行目**: showError関数でDOM操作とメッセージ表示
4. **102-107行目**: 既存メッセージのfadeOut後にfadeIn

#### Step 3: サーバー側のエラー生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ImportHandler.ts | `src/node/handler/ImportHandler.ts` | 各エラー発生箇所を確認 |

**主要処理フロー**:
- **105-108行目**: maxFileSize / uploadFailed
- **134行目**: uploadFailed（未知のファイル形式）
- **152行目**: padHasData
- **175行目**: convertFailed
- **189行目**: uploadFailed（非ASCII）

#### Step 4: ローカライズを確認

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | en.json | `src/locales/en.json` | pad.impexp.*のエラーメッセージ（203-209行目） |

### プログラム呼び出し階層図

```
ImportHandler.doImport(req, res, padId, authorId) [サーバー]
    │
    ├─ [各種エラー発生時]
    │      │
    │      └─ throw new ImportError(status)
    │             │
    │             └─ res.json({code: 1, message: status, ...})
    │
    ▼
[クライアント側]
    │
    └─ $.ajax catch/then
           │
           └─ importErrorMessage(message)
                  │
                  ├─ known配列で既知エラー判定
                  ├─ html10n.get()でローカライズ取得
                  └─ $('#importmessagefail').fadeIn()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

インポートリクエスト ───▶ サーバー処理 ───▶ [エラー発生?]
                                              │
                               ┌──────────────┴──────────────┐
                               │                             │
                            [なし]                        [あり]
                               │                             │
                               ▼                             ▼
                          成功処理               ImportError例外スロー
                                                             │
                                                             ▼
                                                    エラーレスポンス
                                                             │
                                                             ▼
                                                  importErrorMessage
                                                             │
                                              ┌──────────────┴──────────────┐
                                              │                             │
                                        [既知エラー]                   [未知エラー]
                                              │                             │
                                              ▼                             ▼
                                   対応ローカライズ取得           copypaste取得
                                              │                             │
                                              └──────────────┬──────────────┘
                                                             │
                                                             ▼
                                                    #importmessagefail表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pad_impexp.ts | `src/static/js/pad_impexp.ts` | ソース | クライアント側エラー表示処理 |
| ImportHandler.ts | `src/node/handler/ImportHandler.ts` | ソース | サーバー側エラー生成、ImportError定義 |
| pad.html | `src/templates/pad.html` | テンプレート | #importmessagefail要素定義 |
| en.json | `src/locales/en.json` | 設定 | エラーメッセージローカライズ |
| popup_import_export.css | `src/static/css/pad/popup_import_export.css` | スタイル | エラーメッセージスタイル |
