# 通知設計書 22-maxFileSize

## 概要

本ドキュメントは、Etherpadにおいてファイルインポート時にファイルサイズが上限を超えた場合に表示される「maxFileSize」エラー通知の設計について記載する。

### 本通知の処理概要

この通知は、ユーザーがファイルをインポートしようとした際に、アップロードされたファイルのサイズがシステムで設定された上限（importMaxFileSize）を超えている場合に表示されるエラーメッセージである。

**業務上の目的・背景**：サーバーリソースの保護とシステムの安定性確保のため、インポート可能なファイルサイズには上限が設けられている。この通知により、ユーザーに対してファイルサイズの制限があることを明確に伝え、必要に応じてサイト管理者に連絡するよう促す。大きなファイルのアップロードによるメモリ枯渇やサービス停止を防止する。

**通知の送信タイミング**：ユーザーがインポートフォームからファイルをアップロードし、サーバーサイドでFormidableライブラリがファイルを受信・解析する過程で、ファイルサイズがmaxFileSizeを超えたことが検出された時点で発生する。

**通知の受信者**：インポート操作を実行したブラウザセッションのユーザー。クライアントサイドのJavaScriptによって表示されるため、操作を行った本人のみが受信する。

**通知内容の概要**：「ファイルが大きすぎます。インポートに許可されるファイルサイズを増やすには、サイト管理者に連絡してください。」という趣旨のエラーメッセージが表示される。

**期待されるアクション**：ユーザーはファイルを分割するか、より小さいファイルを使用するか、またはサイト管理者に連絡してファイルサイズ上限の引き上げを依頼することが期待される。

## 通知種別

アプリ内通知（フロントエンド表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（HTTP レスポンス） |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

インポートリクエストを送信したクライアントに対してのみ、HTTP レスポンスとしてエラーステータスを返却する。クライアントサイドJavaScriptがこのステータスを解釈し、通知を表示する。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 表示位置 | インポートフォーム内のメッセージエリア |
| スタイルクラス | error（赤色テキスト） |
| 表示方式 | フェードイン |

### 本文テンプレート

```
Import failed: File too big. Contact your site administrator to increase the allowed file size for import
```

日本語（参考）:
```
インポートに失敗しました: ファイルが大きすぎます。インポートに許可されるファイルサイズを増やすには、サイト管理者に連絡してください。
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| status | エラーステータスコード | サーバーレスポンス | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | インポートフォーム送信 | ファイルサイズ > settings.importMaxFileSize | アップロードファイルがサイズ上限を超過 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ファイルサイズ <= importMaxFileSize | ファイルサイズが上限以下の場合はインポートを許可 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザーがファイルを選択してインポート] --> B[サーバーにPOSTリクエスト]
    B --> C[Formidableがファイルを受信]
    C --> D{ファイルサイズチェック}
    D -->|サイズ超過| E[Formidable biggerThanMaxFileSize エラー]
    D -->|サイズOK| F[ファイル処理続行]
    E --> G[ImportError maxFileSize をスロー]
    G --> H[HTTPステータス400でエラーレスポンス返却]
    H --> I[クライアントがエラーメッセージを表示]
    F --> J[インポート処理続行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイルサイズチェックはデータベースアクセス前に実行される）

### 更新テーブル一覧

該当なし（エラー発生時は更新を行わない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| maxFileSize | ファイルサイズ > importMaxFileSize | クライアントにエラーメッセージを表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- ファイルサイズ制限によりDoS攻撃のリスクを軽減
- インポート操作はパッドへの書き込み権限を持つユーザーのみ実行可能
- エラーメッセージには機密情報を含まない
- 実際のファイルサイズ上限値はエラーメッセージに含まれない（セキュリティ上の配慮）

## 備考

- importMaxFileSizeはsettings.jsonで設定可能
- デフォルト値はFormidableライブラリの設定に依存
- サーバー管理者はsettings.jsonの`importMaxFileSize`プロパティで上限を変更可能
- クライアント側での事前チェックは実装されていない（サーバーサイドでのみ検証）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Formidableライブラリのエラーコードとインポートエラーの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ImportHandler.ts | `src/node/handler/ImportHandler.ts` | ImportErrorクラスの定義（39-49行目） |
| 1-2 | ImportHandler.ts | `src/node/handler/ImportHandler.ts` | Formidableの設定（91-95行目） |

**読解のコツ**: FormidableライブラリのmaxFileSizeオプションがどのように使用されているか確認する。

#### Step 2: エントリーポイントを理解する

インポート処理の起点とエラーハンドリングを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pad_impexp.ts | `src/static/js/pad_impexp.ts` | fileInputSubmit関数（49-81行目） |
| 2-2 | pad_impexp.ts | `src/static/js/pad_impexp.ts` | importErrorMessage関数（83-108行目） |

**主要処理フロー**:
1. **49行目**: fileInputSubmit関数でフォーム送信をキャプチャ
2. **84-88行目**: 既知のエラーステータス一覧にmaxFileSizeが含まれる

#### Step 3: サーバーサイド処理を理解する

サーバーでのファイルサイズ検証とエラー発生ロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ImportHandler.ts | `src/node/handler/ImportHandler.ts` | Formidable設定（91-95行目）でmaxFileSizeを設定 |
| 3-2 | ImportHandler.ts | `src/node/handler/ImportHandler.ts` | 100-108行目でform.parseエラーをキャッチ |

**主要処理フロー**:
- **91-95行目**: Formidableインスタンスを作成し、maxFileSizeをsettings.importMaxFileSizeから取得
- **100-101行目**: form.parse()でファイルを解析
- **102-108行目**: エラーをキャッチし、biggerThanMaxFileSizeの場合はmaxFileSizeエラーをスロー

### プログラム呼び出し階層図

```
[Client] pad_impexp.ts
    │
    ├─ fileInputSubmit() [49行目]
    │      │
    │      ├─ $.ajax() POST /p/{padId}/import
    │      │      │
    │      │      └─ [Server] ImportHandler.ts
    │      │             │
    │      │             ├─ new Formidable({maxFileSize: settings.importMaxFileSize}) [91行目]
    │      │             │
    │      │             ├─ form.parse(req) [101行目]
    │      │             │      │
    │      │             │      └─ biggerThanMaxFileSizeエラー発生
    │      │             │
    │      │             └─ throw ImportError('maxFileSize') [105行目]
    │      │
    │      └─ importErrorMessage('maxFileSize') [71行目]
    │
    └─ importErrorMessage() [83行目]
           └─ html10n.get('pad.impexp.maxFileSize')
```

### データフロー図

```
[入力]                      [処理]                           [出力]

大きなファイル ───────▶ Formidable.parse() ───────▶ biggerThanMaxFileSizeエラー
                              │                              │
                              ├─ maxFileSize設定確認         │
                              │                              ▼
                              └─ ファイルサイズ検証    ImportError('maxFileSize')
                                                              │
                                                              ▼
                                                      HTTPレスポンス(400)
                                                              │
                                                              ▼
                                                      importErrorMessage()
                                                              │
                                                              ▼
                                                      エラー通知表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pad_impexp.ts | `src/static/js/pad_impexp.ts` | ソース | クライアント側インポート処理とエラー表示 |
| ImportHandler.ts | `src/node/handler/ImportHandler.ts` | ソース | サーバー側インポート処理とファイルサイズ検証 |
| en.json | `src/locales/en.json` | 設定 | 国際化メッセージ定義（209行目: pad.impexp.maxFileSize） |
| Settings.ts | `src/node/utils/Settings.ts` | ソース | importMaxFileSize設定の読み込み |
| html10n.ts | `src/static/js/vendors/html10n.ts` | ソース | 国際化ライブラリ |
