# 通知設計書 29-設定保存エラー通知

## 概要

本ドキュメントは、Etherpad管理画面において設定の保存が失敗した際に表示されるトースト通知の設計について記載する。

### 本通知の処理概要

この通知は、管理者がSettingsページで設定を編集し、保存ボタンを押した際に、設定がJSON形式として無効であればエラーメッセージをトースト通知として表示する機能である。Radix UIのToastコンポーネントを使用して実装されている。

**業務上の目的・背景**：Etherpadの設定はJSON形式で管理されており、無効なJSONを保存するとシステムが正常に動作しなくなる可能性がある。この通知により、管理者に対して設定の保存に失敗したことを明確にフィードバックし、JSONの修正を促す。クライアントサイドでの事前検証により、サーバーへの無効なデータ送信を防止する。

**通知の送信タイミング**：管理者が設定ページで「Save Settings」ボタンをクリックし、入力されたJSONがisJSONClean関数で無効と判定された直後に表示される。

**通知の受信者**：設定保存操作を実行した管理画面セッションの管理者。クライアントサイドのReactコンポーネントによって表示されるため、操作を行った本人のみが受信する。

**通知内容の概要**：「Error saving settings」というメッセージが失敗を示す赤色のスタイルで表示される。

**期待されるアクション**：管理者は設定テキストエリアに入力したJSONを確認し、シンタックスエラーや構造エラーを修正することが期待される。

## 通知種別

アプリ内通知（Radix Toast）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（クライアントサイド処理） |
| 優先度 | 高（エラー通知） |
| リトライ | なし |

### 送信先決定ロジック

設定保存操作を実行した管理者に対してのみ表示する。Zustand storeのtoastStateを更新することで表示をトリガーする。

## 通知テンプレート

### Radix Toast

| 項目 | 内容 |
|-----|------|
| スタイルクラス | ToastRootFailure（赤色） |
| 自動消去 | あり（Radix Toastのデフォルト動作） |

### 本文テンプレート

```
Error saving settings
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 通知タイトル | setToastStateの引数 | Yes |
| success | 成功/失敗フラグ | setToastStateの引数 | Yes |
| open | 表示/非表示フラグ | setToastStateの引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Save Settingsボタンクリック | isJSONClean(settings) === false | 設定JSONが無効な形式 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| isJSONClean(settings) === true | 設定JSONが有効な形式の場合は成功通知を表示 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理者が設定を編集] --> B[Save Settingsボタンをクリック]
    B --> C{isJSONClean?}
    C -->|false| D[setToastState呼び出し]
    C -->|true| E[成功通知を表示（No.28参照）]
    D --> F[title: 'Error saving settings']
    F --> G[success: false]
    G --> H[open: true]
    H --> I[トースト通知を表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（クライアントサイドのみの処理）

### 更新テーブル一覧

該当なし（エラー時はサーバーへの設定送信を行わない）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| JSON構文エラー | JSON.parseが失敗する形式 | エラートースト通知を表示 |
| JSON構造エラー | 予期しない構造のJSON | エラートースト通知を表示 |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 設定ページへのアクセスには管理者認証が必要
- 無効なJSONはサーバーに送信されない（クライアントサイドで検証）
- エラーメッセージには具体的なエラー内容は含まれない

## 備考

- isJSONClean関数は設定JSONの有効性を検証する
- 検証失敗時はサーバーへの送信をスキップし、即座にエラー通知を表示
- 管理者はJSON形式のエラーを自分で特定・修正する必要がある
- 将来的にはより詳細なエラー情報の表示が望まれる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ToastStateの型定義とZustand storeの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | store.ts | `admin/src/store/store.ts` | ToastState型の定義（6-11行目） |
| 1-2 | store.ts | `admin/src/store/store.ts` | toastStateとsetToastState（23-24行目、41-47行目） |

**読解のコツ**: success: falseの場合にToastRootFailureクラスが適用される流れを確認する。

#### Step 2: エントリーポイントを理解する

設定保存処理とエラートースト表示のトリガーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SettingsPage.tsx | `admin/src/pages/SettingsPage.tsx` | 保存ボタンのonClickハンドラ（17-34行目） |

**主要処理フロー**:
1. **18行目**: onClickハンドラ開始
2. **19行目**: isJSONClean(settings)でJSON検証
3. **27-32行目**: 検証失敗時のsetToastState呼び出し

#### Step 3: 通知表示コンポーネントを理解する

ToastDialogコンポーネントの実装を追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Toast.tsx | `admin/src/utils/Toast.tsx` | ToastDialogコンポーネント全体（5-26行目） |
| 3-2 | Toast.tsx | `admin/src/utils/Toast.tsx` | resultingClassの決定ロジック（7-9行目） |

**主要処理フロー**:
- **7-9行目**: success === falseの場合'ToastRootFailure'が設定される
- **13行目**: Toast.RootにresultingClassが適用される

### プログラム呼び出し階層図

```
[Admin] SettingsPage.tsx
    │
    ├─ IconButton onClick [18行目]
    │      │
    │      ├─ isJSONClean(settings) [19行目]
    │      │      │
    │      │      └─ returns false
    │      │
    │      └─ useStore.getState().setToastState() [28行目]
    │             │
    │             └─ { open: true, title: 'Error saving settings', success: false }
    │
    │
    ▼ Zustand state更新
    │
    │
[Admin] Toast.tsx
    │
    └─ ToastDialog [5行目]
           │
           ├─ useStore(state => state.toastState) [6行目]
           │
           ├─ resultingClass = 'ToastRootFailure' [7-9行目]
           │
           └─ Toast.Root表示（赤色スタイル）[13-23行目]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Save Settingsクリック ───▶ isJSONClean() ───▶ false
                                  │
                                  ▼
                          setToastState({
                            open: true,
                            title: 'Error saving settings',
                            success: false
                          })
                                  │
                                  ▼
                          ToastDialog ───▶ エラートースト通知
                          (ToastRootFailure)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SettingsPage.tsx | `admin/src/pages/SettingsPage.tsx` | ソース | 設定ページと保存処理 |
| Toast.tsx | `admin/src/utils/Toast.tsx` | ソース | トースト通知コンポーネント |
| store.ts | `admin/src/store/store.ts` | ソース | Zustand store（toastState管理） |
| main.tsx | `admin/src/main.tsx` | ソース | Toast.ProviderとToastDialogの配置 |
| utils.ts | `admin/src/utils/utils.ts` | ソース | isJSONClean関数 |
| index.css | `admin/src/index.css` | スタイル | ToastRootFailureクラス定義（赤色） |
