# 通知設計書 30-ログイン失敗通知

## 概要

本ドキュメントは、Etherpad管理画面へのログインが失敗した際に表示されるトースト通知の設計について記載する。

### 本通知の処理概要

この通知は、管理者がログイン画面でユーザー名とパスワードを入力し、ログインを試みた際に、認証が失敗した場合にエラーメッセージをトースト通知として表示する機能である。Radix UIのToastコンポーネントを使用して実装されている。

**業務上の目的・背景**：管理画面へのアクセスにはBasic認証が必要であり、誤った認証情報でのログイン試行は拒否される。この通知により、ユーザーに対して認証が失敗したことを明確にフィードバックし、正しい認証情報の再入力を促す。セキュリティ上、具体的なエラー理由（ユーザー名が間違いかパスワードが間違いか）は表示しない。

**通知の送信タイミング**：管理者がログインフォームで「Login」ボタンをクリックし、サーバーからの認証レスポンスがHTTPエラー（r.ok === false）を返した直後に表示される。

**通知の受信者**：ログイン操作を実行した管理画面セッションのユーザー。クライアントサイドのReactコンポーネントによって表示されるため、操作を行った本人のみが受信する。

**通知内容の概要**：「Login failed」というメッセージが失敗を示す赤色のスタイルで表示される。

**期待されるアクション**：ユーザーはユーザー名とパスワードを確認し、正しい認証情報で再度ログインを試みることが期待される。

## 通知種別

アプリ内通知（Radix Toast）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（HTTPレスポンス後） |
| 優先度 | 高（認証エラー） |
| リトライ | なし |

### 送信先決定ロジック

ログイン操作を実行したユーザーに対してのみ表示する。Zustand storeのtoastStateを更新することで表示をトリガーする。

## 通知テンプレート

### Radix Toast

| 項目 | 内容 |
|-----|------|
| スタイルクラス | ToastRootFailure（赤色） |
| 自動消去 | あり（Radix Toastのデフォルト動作） |

### 本文テンプレート

```
Login failed
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| title | 通知タイトル | setToastStateの引数 | Yes |
| success | 成功/失敗フラグ | setToastStateの引数 | Yes |
| open | 表示/非表示フラグ | setToastStateの引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | Loginボタンクリック | HTTPレスポンスのr.ok === false | 認証が失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| r.ok === true | 認証成功時はダッシュボードにリダイレクト |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[管理者がユーザー名/パスワードを入力] --> B[Loginボタンをクリック]
    B --> C[fetch '/admin-auth/' POST]
    C --> D[Basic認証ヘッダーを送信]
    D --> E{HTTPレスポンス}
    E -->|r.ok === false| F[setToastState呼び出し]
    E -->|r.ok === true| G[navigate('/') でダッシュボードへ]
    F --> H[title: 'Login failed']
    H --> I[success: false]
    I --> J[open: true]
    J --> K[トースト通知を表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（クライアントサイドのみの処理、認証はサーバーサイドで実行）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 認証失敗 | ユーザー名またはパスワードが不正 | エラートースト通知を表示 |
| ネットワークエラー | サーバーに接続できない | console.errorにログ出力 |

### リトライ仕様

該当なし

## 配信設定

### レート制限

該当なし（サーバーサイドでのレート制限は別途実装の可能性）

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 認証情報はBasic認証として送信される（btoa関数でBase64エンコード）
- エラーメッセージには具体的なエラー理由を含まない（ユーザー名/パスワードのどちらが間違いか不明にする）
- ブルートフォース攻撃対策はサーバーサイドで実装される必要がある
- パスワードフィールドは表示/非表示の切り替えが可能（Eye/EyeOffアイコン）

## 備考

- react-hook-formライブラリを使用してフォーム処理を行う
- useNavigateフックを使用してログイン成功時にリダイレクト
- パスワードの表示/非表示はuseStateで管理されるpasswordVisible状態で制御
- フォームのバリデーション（required属性）は各入力フィールドに設定されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォーム入力の型定義とToastStateの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LoginScreen.tsx | `admin/src/pages/LoginScreen.tsx` | Inputs型の定義（7-10行目） |
| 1-2 | store.ts | `admin/src/store/store.ts` | ToastState型の定義（6-11行目） |

**読解のコツ**: Inputs型はusername/passwordの2フィールドを持つシンプルな型。

#### Step 2: エントリーポイントを理解する

ログイン処理とエラートースト表示のトリガーを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LoginScreen.tsx | `admin/src/pages/LoginScreen.tsx` | login関数（20-38行目） |
| 2-2 | LoginScreen.tsx | `admin/src/pages/LoginScreen.tsx` | フォームのonSubmit（44行目） |

**主要処理フロー**:
1. **20行目**: login関数定義（SubmitHandler<Inputs>）
2. **21-25行目**: fetch('/admin-auth/', {method: 'POST', headers: {Authorization: ...}})
3. **26-32行目**: r.ok === falseの場合にsetToastStateでエラー通知設定
4. **33-34行目**: r.ok === trueの場合にnavigate('/')でリダイレクト

#### Step 3: 認証リクエストの構造を理解する

Basic認証ヘッダーの生成方法を追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LoginScreen.tsx | `admin/src/pages/LoginScreen.tsx` | Authorizationヘッダー（23-24行目） |

**主要処理フロー**:
- **24行目**: `Basic ${btoa(\`${username}:${password}\`)}`でBase64エンコード

### プログラム呼び出し階層図

```
[Admin] LoginScreen.tsx
    │
    ├─ <form onSubmit={handleSubmit(login)}> [44行目]
    │      │
    │      └─ login() [20行目]
    │             │
    │             ├─ fetch('/admin-auth/', {...}) [21行目]
    │             │      │
    │             │      ├─ method: 'POST'
    │             │      │
    │             │      └─ headers: { Authorization: `Basic ${btoa(...)}` }
    │             │
    │             ├─ .then(r => {...}) [26行目]
    │             │      │
    │             │      ├─ if (!r.ok) → setToastState() [27行目]
    │             │      │
    │             │      └─ else → navigate('/') [33行目]
    │             │
    │             └─ .catch(e => console.error(e)) [36行目]
    │
    │
    ▼ Zustand state更新（認証失敗時）
    │
    │
[Admin] Toast.tsx
    │
    └─ ToastDialog [5行目]
           │
           ├─ useStore(state => state.toastState) [6行目]
           │
           ├─ resultingClass = 'ToastRootFailure' [7-9行目]
           │
           └─ Toast.Root表示（赤色スタイル）[13-23行目]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

username/password ───▶ login() ───▶ fetch('/admin-auth/')
                                          │
                                          ▼
                                    サーバー認証
                                          │
                                          ▼
                                    HTTPレスポンス
                                          │
                              ┌───────────┴───────────┐
                              ▼                       ▼
                          r.ok === false         r.ok === true
                              │                       │
                              ▼                       ▼
                       setToastState({          navigate('/')
                         open: true,            (ダッシュボードへ)
                         title: 'Login failed',
                         success: false
                       })
                              │
                              ▼
                       ToastDialog ───▶ エラートースト通知
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LoginScreen.tsx | `admin/src/pages/LoginScreen.tsx` | ソース | ログインページとフォーム処理 |
| Toast.tsx | `admin/src/utils/Toast.tsx` | ソース | トースト通知コンポーネント |
| store.ts | `admin/src/store/store.ts` | ソース | Zustand store（toastState管理） |
| main.tsx | `admin/src/main.tsx` | ソース | ルーティング定義（/login） |
| index.css | `admin/src/index.css` | スタイル | ToastRootFailureクラス定義、ログイン画面スタイル |
