# 通知設計書 4-userdup

## 概要

本ドキュメントは、Etherpadにおける重複ウィンドウ検出通知（userdup）の設計を記述する。

### 本通知の処理概要

この通知は同じパッドが同一コンピュータ上の別のブラウザウィンドウで既に開かれていることをユーザーに知らせるモーダルダイアログを表示する機能である。同一ユーザーによる複数ウィンドウでの同時編集を検出し、データ競合を防ぐためにこのウィンドウでの接続を切断する。

**業務上の目的・背景**：Etherpadはリアルタイム共同編集アプリケーションであり、各ユーザーはユニークなトークンで識別される。同一ユーザーが複数のウィンドウで同じパッドを開くと、変更の同期に問題が生じる可能性がある。この通知により、ユーザーに重複状態を知らせ、どちらのウィンドウを使用するか選択させることで、データの整合性を保護する。

**通知の送信タイミング**：サーバーが同一トークン（Cookie）を持つ別のセッションからの接続を検出し、「userdup」理由で切断を通知した時にトリガーされる。

**通知の受信者**：重複接続として検出されたウィンドウのユーザーに対して表示される。

**通知内容の概要**：「Opened in another window」というタイトルと、「This pad seems to be opened in more than one browser window on this computer.」という説明、「Reconnect to use this window instead.」というアドバイスが表示される。「Force reconnect」ボタンにより、このウィンドウでの使用を優先することができる。

**期待されるアクション**：ユーザーは他のウィンドウを閉じるか、「Force reconnect」ボタンをクリックしてこのウィンドウでの編集を継続する。

## 通知種別

アプリ内通知（モーダルダイアログ + オーバーレイ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 手動（Force reconnectボタン） |

### 送信先決定ロジック

サーバーが重複として判定したセッションのブラウザに対してのみ表示される。

## 通知テンプレート

### モーダル通知の場合

| 項目 | 内容 |
|-----|------|
| 表示要素 | `#connectivity .userdup` |
| タイトル | Opened in another window |
| 説明 | This pad seems to be opened in more than one browser window on this computer. |
| アドバイス | Reconnect to use this window instead. |

### 本文テンプレート

```html
<div class="userdup">
  <h1 data-l10n-id="pad.modals.userdup"></h1>
  <h2 data-l10n-id="pad.modals.userdup.explanation"></h2>
  <p id="defaulttext" data-l10n-id="pad.modals.userdup.advice"></p>
  <button id="forcereconnect" class="btn btn-primary" data-l10n-id="pad.modals.forcereconnect"></button>
</div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | この通知には変数がない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバー通知 | message.disconnect='userdup' | 同一トークンの別セッション存在 | サーバーが重複を検出して切断を指示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に切断状態 | status.whatが'disconnected'の場合は重複処理しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[サーバーから切断メッセージ受信] --> B{message.disconnect === 'userdup'?}
    B -->|Yes| C[padconnectionstatus.disconnected 'userdup']
    C --> D[statusを'disconnected'に更新]
    D --> E[knownReasonsに'userdup'が含まれる]
    E --> F[padmodals.showModal 'userdup']
    F --> G[padmodals.showOverlay]
    G --> H[モーダル・オーバーレイ表示]
    H --> I{ユーザー操作}
    I -->|Force reconnect| J[ページリロード]
    I -->|他ウィンドウを閉じる| K[このウィンドウは閉じたまま]
    B -->|No| L[他の切断理由の処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | クライアント側はローカルUI処理のみ | サーバー側でセッション管理を参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | クライアント側でのデータベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 再接続競合 | 両方のウィンドウでForce reconnect | 後から再接続した方が優先される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（手動） |
| リトライ間隔 | ユーザー操作に依存 |
| リトライ対象エラー | userdup切断のみ |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 通知はローカルブラウザ内でのみ処理される
- トークンベースの識別により、同一ユーザーの重複を正確に検出
- セッショントークンはCookieで管理され、HTTPOnly属性で保護されることが推奨

## 備考

- userdupはknownReasons配列に含まれており、専用モーダルが表示される
- 自動再接続タイマー（with_reconnect_timer）は付与されていない
- 国際化対応: pad.modals.userdup, pad.modals.userdup.explanation, pad.modals.userdup.adviceキーで翻訳

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

userdup通知で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | knownReasons配列に'userdup'が含まれていることを確認（76行目） |

**読解のコツ**: userdupはknownReasonsの一つであり、専用のモーダルが表示される。

#### Step 2: エントリーポイントを理解する

サーバーからの切断通知を受け取る起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pad.ts | `src/static/js/pad.ts` | socket.on('message')でのdisconnect処理（333-342行目） |

**主要処理フロー**:
1. **333行目**: obj.disconnectが存在するかチェック
2. **334行目**: padconnectionstatus.disconnected(obj.disconnect)を呼び出し
3. **335行目**: socket.disconnect()でソケット切断

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | disconnected関数でのknownReasons判定（79行目） |
| 3-2 | pad_modals.ts | `src/static/js/pad_modals.ts` | showModal関数（35-43行目） |

**主要処理フロー**:
- **76行目**: knownReasonsに'userdup'が含まれる
- **79行目**: msgが'userdup'の場合、kはそのまま'userdup'になる
- **84行目**: padmodals.showModal('userdup')が呼び出される

#### Step 4: HTMLテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad.html | `src/templates/pad.html` | userdup divの構造（253-258行目） |

**主要処理フロー**:
- **253-258行目**: タイトル、説明、アドバイス、再接続ボタンの構造

#### Step 5: Force reconnectボタンの動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | init関数でのボタンイベント設定（35-37行目） |

**主要処理フロー**:
- **35-37行目**: Force reconnectボタンクリックでwindow.location.reload()

### プログラム呼び出し階層図

```
socket.on('message') (pad.ts:303)
    │
    └─ obj.disconnect === 'userdup'
           │
           └─ padconnectionstatus.disconnected('userdup') (pad_connectionstatus.ts:54)
                  ├─ status = { what: 'disconnected', why: 'userdup' }
                  ├─ knownReasons.indexOf('userdup') !== -1 → k = 'userdup'
                  ├─ padmodals.showModal('userdup') (pad_modals.ts:35)
                  │      ├─ padeditbar.toggleDropDown('none')
                  │      ├─ $('#connectivity .visible').removeClass('visible')
                  │      ├─ $('#connectivity .userdup').addClass('visible')
                  │      └─ padeditbar.toggleDropDown('connectivity')
                  │
                  └─ padmodals.showOverlay (pad_modals.ts:45)

$('#forcereconnect').on('click') (pad_connectionstatus.ts:35)
    │
    └─ window.location.reload()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

サーバー                  pad.ts                        pad_connectionstatus.ts
disconnect='userdup'  ──▶ socket.on('message')          disconnected('userdup')
                              │                              │
                              ▼                              ▼
                         obj.disconnect検出              knownReasons判定
                              │                         k = 'userdup'
                              ▼                              │
                         padconnectionstatus                 ▼
                         .disconnected                  padmodals.showModal
                                                              │
                                                              ▼
                                                        モーダル表示
                                                        (#connectivity .userdup)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pad.ts | `src/static/js/pad.ts` | ソース | メインモジュール、メッセージハンドラ |
| pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | ソース | 接続状態管理、切断理由判定 |
| pad_modals.ts | `src/static/js/pad_modals.ts` | ソース | モーダル表示制御 |
| pad.html | `src/templates/pad.html` | テンプレート | HTMLテンプレート |
| en.json | `src/locales/en.json` | 設定 | 国際化リソース |
