# 通知設計書 5-unauth

## 概要

本ドキュメントは、Etherpadにおける認証エラー通知（unauth）の設計を記述する。

### 本通知の処理概要

この通知はユーザーがパッドを閲覧中に権限が変更され、現在のセッションが無効になったことを知らせるモーダルダイアログを表示する機能である。セキュリティ上の理由で接続が切断された場合に表示され、再認証を促す。

**業務上の目的・背景**：Etherpadでは、パッドごとにアクセス権限を設定できる。閲覧中にパッドの権限が変更された場合（例：パブリックからプライベートへの変更、特定ユーザーのアクセス権削除）、セキュリティを維持するために該当ユーザーの接続を切断する必要がある。この通知により、ユーザーに権限変更を知らせ、適切な対応（再接続または管理者への問い合わせ）を促す。

**通知の送信タイミング**：サーバーがセッションの認証を確認し、権限がないと判断した場合に「unauth」理由で切断を通知した時にトリガーされる。

**通知の受信者**：権限が変更されたパッドを閲覧していたユーザーに対して表示される。

**通知内容の概要**：「Not authorized」というタイトルと、「Your permissions have changed while viewing this page. Try to reconnect.」という説明が表示される。「Force reconnect」ボタンにより、再認証を試みることができる。

**期待されるアクション**：ユーザーは「Force reconnect」ボタンをクリックして再接続を試みる。権限がある場合は接続が復旧し、ない場合は権限拒否画面が表示される。

## 通知種別

アプリ内通知（モーダルダイアログ + オーバーレイ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 手動（Force reconnectボタン） |

### 送信先決定ロジック

サーバーが認証エラーと判定したセッションのブラウザに対してのみ表示される。

## 通知テンプレート

### モーダル通知の場合

| 項目 | 内容 |
|-----|------|
| 表示要素 | `#connectivity .unauth` |
| タイトル | Not authorized |
| 説明 | Your permissions have changed while viewing this page. Try to reconnect. |

### 本文テンプレート

```html
<div class="unauth">
  <h1 data-l10n-id="pad.modals.unauth"></h1>
  <p id="defaulttext" data-l10n-id="pad.modals.unauth.explanation"></p>
  <button id="forcereconnect" class="btn btn-primary" data-l10n-id="pad.modals.forcereconnect"></button>
</div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | この通知には変数がない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバー通知 | message.disconnect='unauth' | 認証/権限エラー | サーバーが権限変更を検出して切断を指示 |
| アクセス権変更 | パッド設定変更 | ユーザーの権限が削除された | パッドの公開設定やユーザー権限が変更された時 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に切断状態 | status.whatが'disconnected'の場合は重複処理しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[サーバーから切断メッセージ受信] --> B{message.disconnect === 'unauth'?}
    B -->|Yes| C[padconnectionstatus.disconnected 'unauth']
    C --> D[statusを'disconnected'に更新]
    D --> E[knownReasonsに'unauth'が含まれる]
    E --> F[padmodals.showModal 'unauth']
    F --> G[padmodals.showOverlay]
    G --> H[モーダル・オーバーレイ表示]
    H --> I{ユーザー操作}
    I -->|Force reconnect| J[ページリロード]
    J --> K{再認証結果}
    K -->|成功| L[パッド編集画面表示]
    K -->|失敗| M[権限拒否画面表示]
    B -->|No| N[他の切断理由の処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | クライアント側はローカルUI処理のみ | サーバー側で権限情報を参照 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | クライアント側でのデータベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 再接続失敗 | 権限が復旧していない場合 | 権限拒否画面が表示される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（手動） |
| リトライ間隔 | ユーザー操作に依存 |
| リトライ対象エラー | unauth切断のみ |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 通知はローカルブラウザ内でのみ処理される
- 権限変更が即座に反映されセキュリティが維持される
- 再接続時にサーバー側で再度権限チェックが行われる
- 具体的な権限変更内容は通知に含まれない（情報漏洩防止）

## 備考

- unauthはknownReasons配列に含まれており、専用モーダルが表示される
- 自動再接続タイマー（with_reconnect_timer）は付与されていない
- 国際化対応: pad.modals.unauth, pad.modals.unauth.explanationキーで翻訳

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

unauth通知で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | knownReasons配列に'unauth'が含まれていることを確認（75行目） |

**読解のコツ**: unauthはknownReasonsの一つであり、専用のモーダルが表示される。

#### Step 2: エントリーポイントを理解する

サーバーからの切断通知を受け取る起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pad.ts | `src/static/js/pad.ts` | socket.on('message')でのdisconnect処理（333-342行目） |

**主要処理フロー**:
1. **333行目**: obj.disconnectが存在するかチェック
2. **334行目**: padconnectionstatus.disconnected(obj.disconnect)を呼び出し
3. **335-340行目**: socket切断、エディタ無効化

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | disconnected関数でのknownReasons判定（79行目） |
| 3-2 | pad_modals.ts | `src/static/js/pad_modals.ts` | showModal関数（35-43行目） |

**主要処理フロー**:
- **75行目**: knownReasonsに'unauth'が含まれる
- **79行目**: msgが'unauth'の場合、kはそのまま'unauth'になる
- **84行目**: padmodals.showModal('unauth')が呼び出される

#### Step 4: HTMLテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad.html | `src/templates/pad.html` | unauth divの構造（259-263行目） |

**主要処理フロー**:
- **259-263行目**: タイトル、説明、再接続ボタンの構造

### プログラム呼び出し階層図

```
socket.on('message') (pad.ts:303)
    │
    └─ obj.disconnect === 'unauth'
           │
           └─ padconnectionstatus.disconnected('unauth') (pad_connectionstatus.ts:54)
                  ├─ status = { what: 'disconnected', why: 'unauth' }
                  ├─ knownReasons.indexOf('unauth') !== -1 → k = 'unauth'
                  ├─ padmodals.showModal('unauth') (pad_modals.ts:35)
                  │      ├─ padeditbar.toggleDropDown('none')
                  │      ├─ $('#connectivity .visible').removeClass('visible')
                  │      ├─ $('#connectivity .unauth').addClass('visible')
                  │      └─ padeditbar.toggleDropDown('connectivity')
                  │
                  └─ padmodals.showOverlay (pad_modals.ts:45)

$('#forcereconnect').on('click') (pad_connectionstatus.ts:35)
    │
    └─ window.location.reload()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

サーバー                  pad.ts                        pad_connectionstatus.ts
disconnect='unauth'   ──▶ socket.on('message')          disconnected('unauth')
                              │                              │
                              ▼                              ▼
                         obj.disconnect検出              knownReasons判定
                              │                         k = 'unauth'
                              ▼                              │
                         padconnectionstatus                 ▼
                         .disconnected                  padmodals.showModal
                                                              │
                                                              ▼
                                                        モーダル表示
                                                        (#connectivity .unauth)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pad.ts | `src/static/js/pad.ts` | ソース | メインモジュール、メッセージハンドラ |
| pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | ソース | 接続状態管理、切断理由判定 |
| pad_modals.ts | `src/static/js/pad_modals.ts` | ソース | モーダル表示制御 |
| pad.html | `src/templates/pad.html` | テンプレート | HTMLテンプレート |
| en.json | `src/locales/en.json` | 設定 | 国際化リソース |
