# 通知設計書 6-looping

## 概要

本ドキュメントは、Etherpadにおける通信ループ検出通知（looping）の設計を記述する。

### 本通知の処理概要

この通知は同期サーバーとの通信に問題があり、通信がループ状態に陥っていることをユーザーに知らせるモーダルダイアログを表示する機能である。主に非互換なファイアウォールやプロキシを経由した接続時に発生する問題を通知する。

**業務上の目的・背景**：Etherpadはリアルタイム共同編集のためにWebSocket通信を使用する。一部のファイアウォールやプロキシサーバーがWebSocket通信を正しく処理できず、接続が不安定になったりループ状態に陥ることがある。この通知により、ユーザーに通信問題の原因を示唆し、ネットワーク環境の確認を促す。

**通知の送信タイミング**：サーバーが通信のループ状態を検出し、「looping」理由で切断を通知した時にトリガーされる。

**通知の受信者**：通信ループが発生したセッションのユーザーに対して表示される。

**通知内容の概要**：「You have been disconnected.」というタイトルと、「There are communication problems with the synchronization server.」という説明、「Perhaps you connected through an incompatible firewall or proxy.」という原因説明が表示される。

**期待されるアクション**：ユーザーはネットワーク環境を確認し、可能であれば直接接続を試みるか、システム管理者に問い合わせる。

## 通知種別

アプリ内通知（モーダルダイアログ + オーバーレイ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし（ネットワーク環境の問題のため） |

### 送信先決定ロジック

通信ループが検出されたセッションのブラウザに対してのみ表示される。

## 通知テンプレート

### モーダル通知の場合

| 項目 | 内容 |
|-----|------|
| 表示要素 | `#connectivity .looping` |
| タイトル | You have been disconnected. |
| 説明 | There are communication problems with the synchronization server. |
| 原因 | Perhaps you connected through an incompatible firewall or proxy. |

### 本文テンプレート

```html
<div class="looping">
  <h1 data-l10n-id="pad.modals.disconnected"></h1>
  <h2 data-l10n-id="pad.modals.looping.explanation"></h2>
  <p data-l10n-id="pad.modals.looping.cause"></p>
</div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | この通知には変数がない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバー通知 | message.disconnect='looping' | 通信ループ検出 | サーバーが通信ループを検出して切断を指示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に切断状態 | status.whatが'disconnected'の場合は重複処理しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[サーバーから切断メッセージ受信] --> B{message.disconnect === 'looping'?}
    B -->|Yes| C[padconnectionstatus.disconnected 'looping']
    C --> D[statusを'disconnected'に更新]
    D --> E[knownReasonsに'looping'が含まれる]
    E --> F[padmodals.showModal 'looping']
    F --> G[padmodals.showOverlay]
    G --> H[モーダル・オーバーレイ表示]
    H --> I[ユーザーは手動でページリロードまたはブラウザを閉じる]
    B -->|No| J[他の切断理由の処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | クライアント側はローカルUI処理のみ | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | クライアント側でのデータベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ネットワーク継続障害 | ファイアウォール/プロキシの問題 | ネットワーク管理者への問い合わせを推奨 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 通知はローカルブラウザ内でのみ処理される
- 通信問題の詳細は非表示（セキュリティ情報を保護）
- ファイアウォール/プロキシの問題を示唆するのみ

## 備考

- loopingはknownReasons配列に含まれており、専用モーダルが表示される
- Force reconnectボタンは表示されない（ネットワーク環境の問題のため再接続しても解決しない）
- 自動再接続タイマー（with_reconnect_timer）は付与されていない
- 国際化対応: pad.modals.disconnected, pad.modals.looping.explanation, pad.modals.looping.causeキーで翻訳

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

looping通知で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | knownReasons配列に'looping'が含まれていることを確認（71行目） |

**読解のコツ**: loopingはknownReasonsの一つであり、専用のモーダルが表示される。

#### Step 2: エントリーポイントを理解する

サーバーからの切断通知を受け取る起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pad.ts | `src/static/js/pad.ts` | socket.on('message')でのdisconnect処理（333-342行目） |

**主要処理フロー**:
1. **333行目**: obj.disconnectが存在するかチェック
2. **334行目**: padconnectionstatus.disconnected(obj.disconnect)を呼び出し

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | disconnected関数でのknownReasons判定（79行目） |
| 3-2 | pad_modals.ts | `src/static/js/pad_modals.ts` | showModal関数（35-43行目） |

**主要処理フロー**:
- **71行目**: knownReasonsに'looping'が含まれる
- **79行目**: msgが'looping'の場合、kはそのまま'looping'になる
- **84行目**: padmodals.showModal('looping')が呼び出される

#### Step 4: HTMLテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad.html | `src/templates/pad.html` | looping divの構造（264-268行目） |

**主要処理フロー**:
- **264-268行目**: タイトル、説明、原因の構造（Force reconnectボタンなし）

### プログラム呼び出し階層図

```
socket.on('message') (pad.ts:303)
    │
    └─ obj.disconnect === 'looping'
           │
           └─ padconnectionstatus.disconnected('looping') (pad_connectionstatus.ts:54)
                  ├─ status = { what: 'disconnected', why: 'looping' }
                  ├─ knownReasons.indexOf('looping') !== -1 → k = 'looping'
                  ├─ padmodals.showModal('looping') (pad_modals.ts:35)
                  │      ├─ padeditbar.toggleDropDown('none')
                  │      ├─ $('#connectivity .visible').removeClass('visible')
                  │      ├─ $('#connectivity .looping').addClass('visible')
                  │      └─ padeditbar.toggleDropDown('connectivity')
                  │
                  └─ padmodals.showOverlay (pad_modals.ts:45)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

サーバー                  pad.ts                        pad_connectionstatus.ts
disconnect='looping'  ──▶ socket.on('message')          disconnected('looping')
                              │                              │
                              ▼                              ▼
                         obj.disconnect検出              knownReasons判定
                              │                         k = 'looping'
                              ▼                              │
                         padconnectionstatus                 ▼
                         .disconnected                  padmodals.showModal
                                                              │
                                                              ▼
                                                        モーダル表示
                                                        (#connectivity .looping)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pad.ts | `src/static/js/pad.ts` | ソース | メインモジュール、メッセージハンドラ |
| pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | ソース | 接続状態管理、切断理由判定 |
| pad_modals.ts | `src/static/js/pad_modals.ts` | ソース | モーダル表示制御 |
| pad.html | `src/templates/pad.html` | テンプレート | HTMLテンプレート |
| en.json | `src/locales/en.json` | 設定 | 国際化リソース |
