# 通知設計書 7-initsocketfail

## 概要

本ドキュメントは、Etherpadにおける初期ソケット接続失敗通知（initsocketfail）の設計を記述する。

### 本通知の処理概要

この通知は初期接続時にサーバーに到達できなかったことをユーザーに知らせるモーダルダイアログを表示する機能である。ブラウザまたはインターネット接続の問題により、同期サーバーへの接続が確立できなかった場合に表示される。

**業務上の目的・背景**：Etherpadはリアルタイム共同編集のためにWebSocket通信を必要とする。初期接続が確立できない場合、ユーザーはパッドの内容を表示・編集できない。この通知により、接続失敗の原因（ブラウザまたはインターネット接続の問題）を示唆し、ユーザーに対処方法を提案する。

**通知の送信タイミング**：初期WebSocket接続の試行中に20秒以上経過してもCONNECTED状態に遷移しない場合にトリガーされる（collab_client.tsの86行目）。

**通知の受信者**：接続に失敗したブラウザセッションのユーザーに対して表示される。

**通知内容の概要**：「Server is unreachable.」というタイトルと、「Couldn't connect to the synchronization server.」という説明、「This is probably due to a problem with your browser or your internet connection.」という原因説明が表示される。

**期待されるアクション**：ユーザーはインターネット接続を確認し、ブラウザを更新するか、しばらく待ってから再度アクセスを試みる。

## 通知種別

アプリ内通知（モーダルダイアログ + オーバーレイ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし（ユーザーによる手動リトライ） |

### 送信先決定ロジック

初期接続に失敗したブラウザセッションのユーザーに対してのみ表示される。

## 通知テンプレート

### モーダル通知の場合

| 項目 | 内容 |
|-----|------|
| 表示要素 | `#connectivity .initsocketfail` |
| タイトル | Server is unreachable. |
| 説明 | Couldn't connect to the synchronization server. |
| 原因 | This is probably due to a problem with your browser or your internet connection. |

### 本文テンプレート

```html
<div class="initsocketfail">
  <h1 data-l10n-id="pad.modals.initsocketfail"></h1>
  <h2 data-l10n-id="pad.modals.initsocketfail.explanation"></h2>
  <p data-l10n-id="pad.modals.initsocketfail.cause"></p>
</div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | この通知には変数がない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 接続タイムアウト | handleUserChanges | 初期接続から20秒以上経過 | CONNECTING状態のまま20秒経過した場合 |
| サーバー通知 | message.disconnect='initsocketfail' | サーバー側で検出 | サーバーが接続失敗を検出した場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に切断状態 | status.whatが'disconnected'の場合は重複処理しない |
| 接続成功 | 20秒以内にCONNECTED状態に遷移した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[初期接続試行開始] --> B[CONNECTING状態で待機]
    B --> C{20秒経過?}
    C -->|No| D[接続成功をチェック]
    D -->|成功| E[CONNECTED状態に遷移]
    D -->|まだ| B
    C -->|Yes| F[setChannelState 'DISCONNECTED', 'initsocketfail']
    F --> G[handleChannelStateChange呼び出し]
    G --> H[padconnectionstatus.disconnected 'initsocketfail']
    H --> I[knownReasonsに'initsocketfail'が含まれる]
    I --> J[padmodals.showModal 'initsocketfail']
    J --> K[padmodals.showOverlay]
    K --> L[モーダル・オーバーレイ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | クライアント側はローカルUI処理のみ | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | クライアント側でのデータベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ネットワーク接続不可 | インターネット接続がない | ネットワーク確認を促す |
| サーバーダウン | サーバーが応答しない | 時間を置いて再試行を促す |
| ブラウザの問題 | WebSocket非対応など | ブラウザ更新を促す |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 通知はローカルブラウザ内でのみ処理される
- サーバー情報は通知に含まれない（セキュリティ保護）

## 備考

- initsocketfailはknownReasons配列に含まれており、専用モーダルが表示される
- Force reconnectボタンは表示されない
- 自動再接続タイマー（with_reconnect_timer）は付与されていない
- 国際化対応: pad.modals.initsocketfail, pad.modals.initsocketfail.explanation, pad.modals.initsocketfail.causeキーで翻訳
- タイムアウト値は20秒（collab_client.ts 85行目）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

initsocketfail通知で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | knownReasons配列に'initsocketfail'が含まれていることを確認（70行目） |
| 1-2 | collab_client.ts | `src/static/js/collab_client.ts` | initialStartConnectTime変数（47行目） |

**読解のコツ**: initsocketfailは初期接続時のタイムアウトによって発生するため、collab_client.tsのタイムアウトロジックが重要。

#### Step 2: エントリーポイントを理解する

初期接続タイムアウトが検出される起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | collab_client.ts | `src/static/js/collab_client.ts` | handleUserChanges関数（77-140行目）のタイムアウトチェック |

**主要処理フロー**:
1. **84-91行目**: チャンネル状態がCONNECTINGかチェック
2. **85行目**: 20秒経過をチェック (now - initialStartConnectTime > 20000)
3. **86行目**: setChannelState('DISCONNECTED', 'initsocketfail')を呼び出し

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pad.ts | `src/static/js/pad.ts` | handleChannelStateChange関数（651-693行目） |
| 3-2 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | disconnected関数でのknownReasons判定（79行目） |

**主要処理フロー**:
- **70行目**: knownReasonsに'initsocketfail'が含まれる
- **79行目**: msgが'initsocketfail'の場合、kはそのまま'initsocketfail'になる
- **84行目**: padmodals.showModal('initsocketfail')が呼び出される

#### Step 4: HTMLテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad.html | `src/templates/pad.html` | initsocketfail divの構造（269-273行目） |

**主要処理フロー**:
- **269-273行目**: タイトル、説明、原因の構造（Force reconnectボタンなし）

### プログラム呼び出し階層図

```
handleUserChanges (collab_client.ts:77)
    │
    └─ チャンネル状態がCONNECTING && 20秒経過
           │
           └─ setChannelState('DISCONNECTED', 'initsocketfail') (collab_client.ts:86)
                  │
                  └─ callbacks.onChannelStateChange (collab_client.ts:358)
                         │
                         └─ pad.handleChannelStateChange (pad.ts:651)
                                │
                                └─ padconnectionstatus.disconnected('initsocketfail')
                                       ├─ status = { what: 'disconnected', why: 'initsocketfail' }
                                       ├─ knownReasons.indexOf('initsocketfail') !== -1
                                       ├─ padmodals.showModal('initsocketfail')
                                       └─ padmodals.showOverlay
```

### データフロー図

```
[入力]                    [処理]                         [出力]

初期接続試行              collab_client.ts              pad.ts
タイムアウト(20秒)  ──▶   handleUserChanges             handleChannelStateChange
                              │                              │
                              ▼                              ▼
                         setChannelState              pad_connectionstatus
                         ('DISCONNECTED',             .disconnected
                          'initsocketfail')                  │
                                                              ▼
                                                        padmodals.showModal
                                                              │
                                                              ▼
                                                        モーダル表示
                                                        (#connectivity .initsocketfail)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| collab_client.ts | `src/static/js/collab_client.ts` | ソース | 接続タイムアウト検出 |
| pad.ts | `src/static/js/pad.ts` | ソース | 状態変更ハンドラ |
| pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | ソース | 接続状態管理、切断理由判定 |
| pad_modals.ts | `src/static/js/pad_modals.ts` | ソース | モーダル表示制御 |
| pad.html | `src/templates/pad.html` | テンプレート | HTMLテンプレート |
| en.json | `src/locales/en.json` | 設定 | 国際化リソース |
