# 通知設計書 8-slowcommit

## 概要

本ドキュメントは、Etherpadにおけるサーバー応答遅延通知（slowcommit）の設計を記述する。

### 本通知の処理概要

この通知はサーバーが編集内容の同期（コミット）に応答しないことをユーザーに知らせるモーダルダイアログを表示する機能である。ネットワーク接続の問題により、編集内容がサーバーに反映されない状態を通知する。自動再接続タイマーと手動再接続ボタンを提供する。

**業務上の目的・背景**：Etherpadはリアルタイム共同編集アプリケーションであり、ユーザーの編集内容はサーバーにコミットされて他のユーザーと共有される。コミットに時間がかかりすぎる場合、ネットワーク問題の可能性が高い。この通知により、ユーザーに遅延を知らせ、自動または手動での再接続を促す。

**通知の送信タイミング**：編集内容のコミット送信後20秒以上経過してもサーバーからの応答（ACCEPT_COMMIT）がない場合にトリガーされる（collab_client.tsの95-97行目）。

**通知の受信者**：コミット応答が遅延しているセッションのユーザーに対して表示される。

**通知内容の概要**：「You have been disconnected.」というタイトルと、「The server is not responding.」という説明、「This could be due to problems with network connectivity.」という原因説明が表示される。「Force reconnect」ボタンと自動再接続カウントダウンタイマーも表示される。

**期待されるアクション**：ユーザーは自動再接続を待つか、「Force reconnect」ボタンをクリックして手動で再接続を試みる。

## 通知種別

アプリ内通知（モーダルダイアログ + オーバーレイ + 自動再接続タイマー）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 自動（自動再接続タイマー） |

### 送信先決定ロジック

コミット応答が遅延しているセッションのブラウザに対してのみ表示される。

## 通知テンプレート

### モーダル通知の場合

| 項目 | 内容 |
|-----|------|
| 表示要素 | `#connectivity .slowcommit` |
| タイトル | You have been disconnected. |
| 説明 | The server is not responding. |
| 原因 | This could be due to problems with network connectivity. |

### 本文テンプレート

```html
<div class="slowcommit with_reconnect_timer">
  <h1 data-l10n-id="pad.modals.disconnected"></h1>
  <h2 data-l10n-id="pad.modals.slowcommit.explanation"></h2>
  <p id="defaulttext" data-l10n-id="pad.modals.slowcommit.cause"></p>
  <button id="forcereconnect" class="btn btn-primary" data-l10n-id="pad.modals.forcereconnect"></button>
</div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | この通知には変数がない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コミットタイムアウト | handleUserChanges | コミット送信後20秒経過 | 最終コミット時刻から20秒以上経過 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に切断状態 | status.whatが'disconnected'の場合は重複処理しない |
| コミット応答受信 | 20秒以内にACCEPT_COMMITを受信した場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ユーザー編集をコミット] --> B[lastCommitTime記録]
    B --> C[サーバー応答を待機]
    C --> D{20秒経過?}
    D -->|No| E{応答受信?}
    E -->|Yes| F[acceptCommit処理]
    E -->|No| C
    D -->|Yes| G[setChannelState 'DISCONNECTED', 'slowcommit']
    G --> H[handleChannelStateChange呼び出し]
    H --> I[padconnectionstatus.disconnected 'slowcommit']
    I --> J[knownReasonsに'slowcommit'が含まれる]
    J --> K[padmodals.showModal 'slowcommit']
    K --> L[自動再接続タイマー開始]
    L --> M[padmodals.showOverlay]
    M --> N[モーダル・オーバーレイ表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | クライアント側はローカルUI処理のみ | - |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | クライアント側でのデータベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ネットワーク遅延 | サーバー応答が遅い | 自動再接続を待つ |
| サーバー過負荷 | サーバーが処理できない | 時間を置いて再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（ユーザーがキャンセルするまで） |
| リトライ間隔 | clientVars.automaticReconnectionTimeout × 2^n 秒 |
| リトライ対象エラー | slowcommit切断 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 通知はローカルブラウザ内でのみ処理される
- 編集内容はローカルに保持されており、再接続後に再送信される

## 備考

- slowcommitはknownReasons配列に含まれており、専用モーダルが表示される
- with_reconnect_timerクラスにより自動再接続機能が有効
- タイムアウト値は20秒（collab_client.ts 95行目）
- 5秒経過時点でonConnectionTrouble('SLOW')も発火する（98-99行目）
- 国際化対応: pad.modals.disconnected, pad.modals.slowcommit.explanation, pad.modals.slowcommit.causeキーで翻訳

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

slowcommit通知で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | collab_client.ts | `src/static/js/collab_client.ts` | committing変数（43行目）とlastCommitTime変数（46行目） |
| 1-2 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | knownReasons配列に'slowcommit'が含まれていることを確認（74行目） |

**読解のコツ**: slowcommitはコミット中（committing=true）の状態でタイムアウトが発生した場合にトリガーされる。

#### Step 2: エントリーポイントを理解する

コミットタイムアウトが検出される起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | collab_client.ts | `src/static/js/collab_client.ts` | handleUserChanges関数（77-140行目）のコミットタイムアウトチェック |

**主要処理フロー**:
1. **94行目**: committing状態かチェック
2. **95行目**: 20秒経過をチェック (now - lastCommitTime > 20000)
3. **96-97行目**: setChannelState('DISCONNECTED', 'slowcommit')を呼び出し
4. **98-99行目**: 5秒経過時はonConnectionTrouble('SLOW')を呼び出し

#### Step 3: コミット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | collab_client.ts | `src/static/js/collab_client.ts` | コミット送信処理（117-130行目） |
| 3-2 | collab_client.ts | `src/static/js/collab_client.ts` | acceptCommit処理（142-150行目） |

**主要処理フロー**:
- **119行目**: lastCommitTimeを現在時刻に更新
- **120行目**: committing = true に設定
- **142-149行目**: ACCEPT_COMMIT受信時の処理

#### Step 4: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | disconnected関数でのknownReasons判定（79行目） |
| 4-2 | pad_modals.ts | `src/static/js/pad_modals.ts` | showModal関数での自動再接続タイマー連携（41行目） |

#### Step 5: HTMLテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | pad.html | `src/templates/pad.html` | slowcommit divの構造（274-279行目） |

**主要処理フロー**:
- **274行目**: with_reconnect_timerクラスあり
- **278行目**: Force reconnectボタンあり

### プログラム呼び出し階層図

```
handleUserChanges (collab_client.ts:77)
    │
    ├─ コミット送信時
    │      ├─ lastCommitTime = now (119行目)
    │      └─ committing = true (120行目)
    │
    └─ タイムアウトチェック時 (committing && 20秒経過)
           │
           └─ setChannelState('DISCONNECTED', 'slowcommit') (97行目)
                  │
                  └─ callbacks.onChannelStateChange
                         │
                         └─ pad.handleChannelStateChange (pad.ts:651)
                                │
                                └─ padconnectionstatus.disconnected('slowcommit')
                                       ├─ status = { what: 'disconnected', why: 'slowcommit' }
                                       ├─ knownReasons.indexOf('slowcommit') !== -1
                                       ├─ padmodals.showModal('slowcommit')
                                       │      └─ automaticReconnect.showCountDownTimer
                                       └─ padmodals.showOverlay
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ユーザー編集              collab_client.ts              collab_client.ts
                    ──▶   handleUserChanges             setChannelState
                              │                              │
                              ▼                              ▼
                         コミット送信                   タイムアウト検出
                         lastCommitTime更新            (20秒経過)
                              │                              │
                              ▼                              ▼
                         サーバー応答待機              'DISCONNECTED', 'slowcommit'
                              │                              │
                              ▼                              ▼
                         ACCEPT_COMMIT待ち             pad_connectionstatus
                         (最大20秒)                    .disconnected
                                                              │
                                                              ▼
                                                        padmodals.showModal
                                                        + 自動再接続タイマー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| collab_client.ts | `src/static/js/collab_client.ts` | ソース | コミット処理、タイムアウト検出 |
| pad.ts | `src/static/js/pad.ts` | ソース | 状態変更ハンドラ |
| pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | ソース | 接続状態管理、切断理由判定 |
| pad_modals.ts | `src/static/js/pad_modals.ts` | ソース | モーダル表示制御 |
| pad_automatic_reconnect.ts | `src/static/js/pad_automatic_reconnect.ts` | ソース | 自動再接続タイマー |
| pad.html | `src/templates/pad.html` | テンプレート | HTMLテンプレート |
| en.json | `src/locales/en.json` | 設定 | 国際化リソース |
