# 通知設計書 9-badChangeset

## 概要

本ドキュメントは、Etherpadにおける不正な編集検出通知（badChangeset）の設計を記述する。

### 本通知の処理概要

この通知はユーザーが行った編集がサーバーによって不正（illegal）と判定されたことを知らせるモーダルダイアログを表示する機能である。サーバー設定の問題や予期しない動作によって発生する可能性があり、自動再接続タイマーと手動再接続ボタンを提供する。

**業務上の目的・背景**：Etherpadは変更セット（Changeset）と呼ばれる形式で編集内容を管理する。変更セットの検証はサーバー側で行われ、不正なフォーマットや整合性のない変更は拒否される。この通知により、ユーザーに問題の発生を知らせ、再接続による復旧を促す。サービス管理者への連絡も推奨される。

**通知の送信タイミング**：サーバーが変更セットの検証に失敗し、「badChangeset」理由で切断を通知した時にトリガーされる。

**通知の受信者**：不正な変更セットを送信したセッションのユーザーに対して表示される。

**通知内容の概要**：「You have been disconnected.」というタイトルと、「An edit you have made was classified illegal by the synchronization server.」という説明、「This could be due to a wrong server configuration or some other unexpected behavior. Please contact the service administrator, if you feel this is an error. Try to reconnect in order to continue editing.」という原因説明が表示される。「Force reconnect」ボタンと自動再接続カウントダウンタイマーも表示される。

**期待されるアクション**：ユーザーは自動再接続を待つか、「Force reconnect」ボタンをクリックして手動で再接続を試みる。問題が継続する場合はサービス管理者に連絡する。

## 通知種別

アプリ内通知（モーダルダイアログ + オーバーレイ + 自動再接続タイマー）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 自動（自動再接続タイマー） |

### 送信先決定ロジック

不正な変更セットを送信したセッションのブラウザに対してのみ表示される。

## 通知テンプレート

### モーダル通知の場合

| 項目 | 内容 |
|-----|------|
| 表示要素 | `#connectivity .badChangeset` |
| タイトル | You have been disconnected. |
| 説明 | An edit you have made was classified illegal by the synchronization server. |
| 原因 | This could be due to a wrong server configuration or some other unexpected behavior. Please contact the service administrator, if you feel this is an error. Try to reconnect in order to continue editing. |

### 本文テンプレート

```html
<div class="badChangeset with_reconnect_timer">
  <h1 data-l10n-id="pad.modals.disconnected"></h1>
  <h2 data-l10n-id="pad.modals.badChangeset.explanation"></h2>
  <p id="defaulttext" data-l10n-id="pad.modals.badChangeset.cause"></p>
  <button id="forcereconnect" class="btn btn-primary" data-l10n-id="pad.modals.forcereconnect"></button>
</div>
```

### 添付ファイル

なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | この通知には変数がない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| サーバー通知 | message.disconnect='badChangeset' | 変更セット検証失敗 | サーバーが変更セットを不正と判定して切断を指示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に切断状態 | status.whatが'disconnected'の場合は重複処理しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[サーバーから切断メッセージ受信] --> B{message.disconnect === 'badChangeset'?}
    B -->|Yes| C[padconnectionstatus.disconnected 'badChangeset']
    C --> D[statusを'disconnected'に更新]
    D --> E[knownReasonsに'badChangeset'が含まれる]
    E --> F[padmodals.showModal 'badChangeset']
    F --> G[自動再接続タイマー開始]
    G --> H[padmodals.showOverlay]
    H --> I[モーダル・オーバーレイ表示]
    I --> J{ユーザー操作/タイマー期限}
    J -->|Force reconnect/タイマー期限| K[ページリロード]
    J -->|キャンセル| L[タイマー停止]
    B -->|No| M[他の切断理由の処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | クライアント側はローカルUI処理のみ | サーバー側で変更セット検証 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | クライアント側でのデータベース更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 変更セット不正 | クライアントのバグまたはサーバー設定問題 | 再接続して復旧を試みる |
| 継続的な失敗 | 設定問題が解決していない | サービス管理者への連絡 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（ユーザーがキャンセルするまで） |
| リトライ間隔 | clientVars.automaticReconnectionTimeout × 2^n 秒 |
| リトライ対象エラー | badChangeset切断 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間対応）

## セキュリティ考慮事項

- 通知はローカルブラウザ内でのみ処理される
- 不正な変更セットの詳細はクライアントには表示されない
- サーバー側でのセキュリティチェックにより不正なデータが保存されることを防止

## 備考

- badChangesetはknownReasons配列に含まれており、専用モーダルが表示される
- with_reconnect_timerクラスにより自動再接続機能が有効
- 国際化対応: pad.modals.disconnected, pad.modals.badChangeset.explanation, pad.modals.badChangeset.causeキーで翻訳
- 変更セットの詳細についてはChangeset仕様を参照

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

badChangeset通知で使用されるデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | knownReasons配列に'badChangeset'が含まれていることを確認（66行目） |

**読解のコツ**: badChangesetはknownReasonsの一つであり、専用のモーダルが表示される。

#### Step 2: エントリーポイントを理解する

サーバーからの切断通知を受け取る起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | pad.ts | `src/static/js/pad.ts` | socket.on('message')でのdisconnect処理（333-342行目） |

**主要処理フロー**:
1. **333行目**: obj.disconnectが存在するかチェック
2. **334行目**: padconnectionstatus.disconnected(obj.disconnect)を呼び出し

#### Step 3: 通知表示処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | disconnected関数でのknownReasons判定（79行目） |
| 3-2 | pad_modals.ts | `src/static/js/pad_modals.ts` | showModal関数での自動再接続タイマー連携（41行目） |

**主要処理フロー**:
- **66行目**: knownReasonsに'badChangeset'が含まれる
- **79行目**: msgが'badChangeset'の場合、kはそのまま'badChangeset'になる
- **84行目**: padmodals.showModal('badChangeset')が呼び出される
- **41行目**: with_reconnect_timerクラスにより自動再接続タイマー開始

#### Step 4: HTMLテンプレートを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad.html | `src/templates/pad.html` | badChangeset divの構造（280-285行目） |

**主要処理フロー**:
- **280行目**: with_reconnect_timerクラスあり
- **284行目**: Force reconnectボタンあり

### プログラム呼び出し階層図

```
socket.on('message') (pad.ts:303)
    │
    └─ obj.disconnect === 'badChangeset'
           │
           └─ padconnectionstatus.disconnected('badChangeset') (pad_connectionstatus.ts:54)
                  ├─ status = { what: 'disconnected', why: 'badChangeset' }
                  ├─ knownReasons.indexOf('badChangeset') !== -1 → k = 'badChangeset'
                  ├─ padmodals.showModal('badChangeset') (pad_modals.ts:35)
                  │      ├─ padeditbar.toggleDropDown('none')
                  │      ├─ $('#connectivity .visible').removeClass('visible')
                  │      ├─ $('#connectivity .badChangeset').addClass('visible')
                  │      ├─ automaticReconnect.showCountDownTimerToReconnectOnModal
                  │      └─ padeditbar.toggleDropDown('connectivity')
                  │
                  └─ padmodals.showOverlay (pad_modals.ts:45)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

サーバー                  pad.ts                        pad_connectionstatus.ts
disconnect=           ──▶ socket.on('message')          disconnected('badChangeset')
'badChangeset'               │                              │
                              ▼                              ▼
                         obj.disconnect検出              knownReasons判定
                              │                         k = 'badChangeset'
                              ▼                              │
                         padconnectionstatus                 ▼
                         .disconnected                  padmodals.showModal
                                                              │
                                                              ▼
                                                        自動再接続タイマー
                                                        + モーダル表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| pad.ts | `src/static/js/pad.ts` | ソース | メインモジュール、メッセージハンドラ |
| pad_connectionstatus.ts | `src/static/js/pad_connectionstatus.ts` | ソース | 接続状態管理、切断理由判定 |
| pad_modals.ts | `src/static/js/pad_modals.ts` | ソース | モーダル表示制御 |
| pad_automatic_reconnect.ts | `src/static/js/pad_automatic_reconnect.ts` | ソース | 自動再接続タイマー |
| pad.html | `src/templates/pad.html` | テンプレート | HTMLテンプレート |
| en.json | `src/locales/en.json` | 設定 | 国際化リソース |
