---
generated_at: 2026-02-10 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-connected.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_connectionstatus.ts` 29-45行目
- E-02: `src/static/js/pad_modals.ts` 35-51行目
- E-03: `src/static/js/pad.ts` 651-700行目
- E-04: `src/templates/pad.html` 242-318行目
- E-05: `src/locales/en.json` 113行目
- E-06: `src/static/js/collab_client.ts` 355-359行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | connected通知はサーバー接続確立時に表示される | E-01, E-03 | ○ |
| C-02 | 通知はpadmodals.showModal('connected')で表示される | E-01 (43行目) | ○ |
| C-03 | 通知表示時にオーバーレイが非表示になる | E-01 (44行目), E-02 (49-51行目) | ○ |
| C-04 | チャンネル状態が'CONNECTED'に変更された時にトリガー | E-03 (654-658行目) | ○ |
| C-05 | padeditor.enable()が呼び出される | E-03 (655行目) | ○ |
| C-06 | padeditbar.enable()が呼び出される | E-03 (656行目) | ○ |
| C-07 | padimpexp.enable()が呼び出される | E-03 (657行目) | ○ |
| C-08 | 表示メッセージは「Connected.」 | E-05 | ○ |
| C-09 | 国際化キーは「pad.modals.connected」 | E-04 (245行目), E-05 | ○ |
| C-10 | HTMLテンプレートに.connected divが存在 | E-04 (244-246行目) | ○ |
| C-11 | setChannelStateでコールバックが呼び出される | E-06 (355-359行目) | ○ |
| C-12 | 1秒後にモーダルが自動非表示になる | E-03 (698-700行目) | ○ |
| C-13 | 接続状態はstatusオブジェクトで管理される | E-01 (29-31行目) | ○ |
| C-14 | 通知はブラウザローカルで処理される | E-01, E-02 | ○ |
| C-15 | データベースアクセスはない | E-01, E-02, E-03 | ○ |
| C-16 | visibleクラスの切り替えで表示制御 | E-02 (37-38行目) | ○ |
| C-17 | toolbar-overlayが非表示になる | E-02 (50行目) | ○ |
| C-18 | 再接続成功時も同じ通知が表示される | E-03 (654-658行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] pad_connectionstatus.ts の connected 関数の動作を確認
- [ ] pad_modals.ts の showModal 関数の動作を確認
- [ ] pad.html の connectivity セクションの構造を確認
- [ ] 国際化キー pad.modals.connected が正しく設定されているか確認
