---
generated_at: 2026-02-10 14:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：11-deleted 通知設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/handler/PadMessageHandler.ts` 181-189行目（kickSessionsFromPad関数）
- E-02: `src/static/js/pad_connectionstatus.ts` 54-86行目（disconnected関数）
- E-03: `src/static/js/pad_connectionstatus.ts` 65-77行目（knownReasons配列）
- E-04: `src/static/js/pad_modals.ts` 35-43行目（showModal関数）
- E-05: `src/templates/pad.html` 291-294行目（deleted div要素）
- E-06: `src/locales/en.json` 142-143行目（pad.modals.deleted, pad.modals.deleted.explanation）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kickSessionsFromPadで{disconnect: 'deleted'}メッセージが送信される | E-01 | ○ |
| C-02 | socketio.in(padID).emit()でパッドルームにブロードキャストされる | E-01 | ○ |
| C-03 | 接続ユーザーがいない場合は送信がスキップされる | E-01 | ○ |
| C-04 | クライアント側でdisconnected関数がメッセージを処理する | E-02 | ○ |
| C-05 | knownReasons配列に'deleted'が含まれている | E-03 | ○ |
| C-06 | padmodals.showModal()でモーダルが表示される | E-02, E-04 | ○ |
| C-07 | padmodals.showOverlay()でオーバーレイが表示される | E-02, E-04 | ○ |
| C-08 | deleted用のHTMLテンプレートがpad.htmlに存在する | E-05 | ○ |
| C-09 | 通知タイトルは「Deleted.」である | E-06 | ○ |
| C-10 | 説明文は「This pad has been removed.」である | E-06 | ○ |
| C-11 | Force reconnectボタンは表示されない | E-05 | ○ |
| C-12 | 自動再接続タイマーは適用されない（with_reconnect_timerクラスなし） | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] kickSessionsFromPad関数の実装が設計書の記述と一致するか確認
- [ ] ローカライズキーが正しく設定されているか確認
- [ ] モーダルHTMLの構造が設計書と一致するか確認
