---
generated_at: 2026-02-10 14:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-rejected 通知設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されている

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/handler/PadMessageHandler.ts` 77-93行目（sessioninfos構造体コメント）
- E-02: `src/node/handler/PadMessageHandler.ts` 331-332行目（securityManager.checkAccess呼び出し）
- E-03: `src/node/handler/PadMessageHandler.ts` 337-348行目（Author ID検証とrejected送信）
- E-04: `src/static/js/pad_connectionstatus.ts` 73行目（knownReasons配列にrejected含む）
- E-05: `src/templates/pad.html` 299-303行目（rejected div要素）
- E-06: `src/locales/en.json` 148-149行目（pad.modals.rejected関連）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sessioninfosにauthor属性が含まれる | E-01 | ○ |
| C-02 | securityManager.checkAccessでauthorIDを取得する | E-02 | ○ |
| C-03 | Author ID不一致時に{disconnect: 'rejected'}が送信される | E-03 | ○ |
| C-04 | エラーログに詳細情報が出力される | E-03 | ○ |
| C-05 | knownReasons配列に'rejected'が含まれている | E-04 | ○ |
| C-06 | rejected用のHTMLテンプレートがpad.htmlに存在する | E-05 | ○ |
| C-07 | タイトルはpad.modals.disconnected（共通の切断タイトル） | E-05 | ○ |
| C-08 | 説明文はpad.modals.rejected.explanation | E-05, E-06 | ○ |
| C-09 | 原因説明はpad.modals.rejected.cause | E-05, E-06 | ○ |
| C-10 | with_reconnect_timerクラスがない（自動再接続なし） | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] Author ID不一致検出のセキュリティ上の妥当性を確認
- [ ] ログ出力に機密情報が含まれていないか確認
- [ ] ローカライズキーが正しく設定されているか確認
