---
generated_at: 2026-02-10 14:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-リビジョン保存通知 設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠が確認されている

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_savedrevs.ts` 22-35行目（saveNow関数全体）
- E-02: `src/static/js/pad_savedrevs.ts` 23行目（SAVE_REVISIONメッセージ送信）
- E-03: `src/static/js/pad_savedrevs.ts` 24-34行目（$.gritter.add呼び出し）
- E-04: `src/node/handler/PadMessageHandler.ts` 444-448行目（handleSaveRevisionMessage関数）
- E-05: `src/locales/en.json` 194-195行目（pad.savedrevs.marked, pad.savedrevs.timeslider）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | saveNow関数でSAVE_REVISIONメッセージが送信される | E-02 | ○ |
| C-02 | $.gritter.addで通知が表示される | E-03 | ○ |
| C-03 | 通知タイトルはpad.savedrevs.marked | E-03, E-05 | ○ |
| C-04 | 通知テキストはpad.savedrevs.timeslider | E-03, E-05 | ○ |
| C-05 | フォールバック値が設定されている | E-03 | ○ |
| C-06 | stickyはfalseに設定されている | E-03 | ○ |
| C-07 | 表示時間は3000ミリ秒 | E-03 | ○ |
| C-08 | class_nameはsaved-revision | E-03 | ○ |
| C-09 | handleSaveRevisionMessageでpad.addSavedRevisionが呼ばれる | E-04 | ○ |
| C-10 | authorIdが保存される | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠が確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] 楽観的UIパターンが適切か確認（サーバーエラー時の挙動）
- [ ] ローカライズキーが正しく設定されているか確認
- [ ] フォールバック値が適切か確認
