---
generated_at: 2026-02-10 14:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-reconnecting.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_connectionstatus.ts` 46-53行目
- E-02: `src/static/js/pad_modals.ts` 35-51行目
- E-03: `src/static/js/pad.ts` 248-263行目, 280行目, 659-663行目, 228-234行目
- E-04: `src/templates/pad.html` 247-252行目
- E-05: `src/locales/en.json` 114行目
- E-06: `src/static/js/collab_client.ts` 355-359行目, 426行目, 432行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | reconnecting通知は再接続試行中に表示される | E-01, E-03 | ○ |
| C-02 | 通知はpadmodals.showModal('reconnecting')で表示される | E-01 (51行目) | ○ |
| C-03 | 通知表示時にオーバーレイが表示される | E-01 (52行目), E-02 (45-48行目) | ○ |
| C-04 | socket.on('disconnect')でトリガーされる | E-03 (257-263行目) | ○ |
| C-05 | socketReconnecting関数が呼び出される | E-03 (248-255行目, 262行目) | ○ |
| C-06 | reconnect_attemptでもトリガーされる | E-03 (280行目) | ○ |
| C-07 | padeditor.disable()が呼び出される | E-03 (660行目) | ○ |
| C-08 | padeditbar.disable()が呼び出される | E-03 (661行目) | ○ |
| C-09 | padimpexp.disable()が呼び出される | E-03 (662行目) | ○ |
| C-10 | 表示メッセージは「Reconnecting to your pad...」 | E-05 | ○ |
| C-11 | 国際化キーは「pad.modals.reconnecting」 | E-04 (248行目), E-05 | ○ |
| C-12 | HTMLにローディングスピナーがある | E-04 (249-251行目) | ○ |
| C-13 | 再接続試行回数は5回 | E-03 (230行目) | ○ |
| C-14 | 再接続待機時間は1000〜5000ms | E-03 (232-233行目) | ○ |
| C-15 | collabClient.setStateIdle()が呼び出される | E-03 (251行目), E-06 | ○ |
| C-16 | collabClient.setIsPendingRevision(true)が呼び出される | E-03 (252行目), E-06 | ○ |
| C-17 | collabClient.setChannelState('RECONNECTING')が呼び出される | E-03 (253行目), E-06 | ○ |
| C-18 | status.whatが'reconnecting'に設定される | E-01 (47-49行目) | ○ |
| C-19 | ブランドロゴが表示される | E-04 (250行目) | ○ |
| C-20 | toolbar-overlayが表示される | E-02 (47行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] pad.ts の socket.io イベントハンドラの動作を確認
- [ ] pad_connectionstatus.ts の reconnecting 関数の動作を確認
- [ ] pad_modals.ts の showOverlay 関数の動作を確認
- [ ] socket.io の再接続設定パラメータが正しいか確認
